/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.platron;

import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGRulesHelper;
import com.gridnine.xtrip.server.pg.PGServlet;
import com.gridnine.xtrip.server.pg.PaymentChecker;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.platron.HandlerSecurity;
import com.gridnine.xtrip.server.pg.platron.Platron2PGConnector;
import com.gridnine.xtrip.server.pg.platron.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Platron2PGServlet
extends PGServlet {
    private static final long serialVersionUID = -3694655557374307984L;
    private static final Logger log = LoggerFactory.getLogger(Platron2PGServlet.class);

    protected PgName getId() {
        return PgName.PLATRON2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
        LinkedList pgLog;
        block25: {
            String secretKey;
            Element response;
            Element request;
            Date startDate;
            block24: {
                log.debug("service() BEGIN");
                PGInvocationContext.get().begin(InvocationName.SERVLET_SERVICE.toString());
                startDate = new Date();
                boolean success = false;
                String paymentId = null;
                Payment payment = null;
                byte[] inputData = req.getParameter("pg_xml").getBytes();
                request = null;
                Document doc = DocumentBuilderHelper.newDocument();
                response = doc.createElement("response");
                doc.appendChild(response);
                pgLog = new LinkedList();
                secretKey = null;
                try {
                    LogicalStorage.get().authorizeAsSystem();
                    request = DocumentBuilderHelper.parse((InputStream)new ByteArrayInputStream(inputData)).getDocumentElement();
                    paymentId = XHelper.readString((Element)request, (String)"pg_order_id");
                    try (NamedLock lock = this.getLock(paymentId);){
                        if (!lock.tryLock()) {
                            throw new Exception("another request for this pg_order_id in progress");
                        }
                        try {
                            PGInvocationContext.get().setPaymentId(paymentId);
                            payment = this.getFromQueue(paymentId);
                            if (payment == null) {
                                throw new Exception("payment not found");
                            }
                            SalesContext salesCtx = PaymentHelper.restoreSalesContext((Payment)payment);
                            secretKey = PGRulesHelper.getPGParameters((SalesContext)salesCtx, (PgName)this.getId(), (Payment)payment).getPgPassword();
                            HandlerSecurity.checkSecurity(request, ((Platron2PGConnector)this.getConnector()).getConnectorConfiguration().getResultUrl(), secretKey);
                            payment.setPaymentType(Util.paymentTypeFromString(XHelper.readString((Element)request, (String)"pg_payment_system")));
                            success = "1".equals(XHelper.readString((Element)request, (String)"pg_result"));
                            XHelper.writeString((Element)response, (String)"pg_status", (String)"ok");
                            if (success) {
                                PaymentChecker.schedule((Payment)payment, (SalesContext)salesCtx, (PgName)PgName.PLATRON2);
                            } else {
                                payment.setStatus(PaymentStatus.FAILED);
                                this.paymentFailed(payment, new LinkedList());
                            }
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                    if (secretKey != null) break block24;
                }
                catch (Throwable t) {
                    try {
                        log.error("service failed", t);
                        XHelper.writeString((Element)response, (String)"pg_status", (String)"error");
                        XHelper.writeString((Element)response, (String)"pg_error_description", (String)t.getMessage());
                        return;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (secretKey == null) {
                            res.sendError(500, "could not provide signature");
                            PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, null, null);
                        } else {
                            HandlerSecurity.injectSecurity(response, ((Platron2PGConnector)this.getConnector()).getConnectorConfiguration().getResultUrl(), secretKey);
                            PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, null);
                            try {
                                XUtil.newTransformer().transform(new DOMSource(response), new StreamResult((OutputStream)res.getOutputStream()));
                            }
                            catch (Throwable t2) {
                                res.sendError(500, t2.getMessage());
                                log.error("response sending failed", t2);
                            }
                        }
                        PGInvocationContext.get().end(this.getConnector(), pgLog);
                        LogicalStorage.reset();
                    }
                }
                res.sendError(500, "could not provide signature");
                PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, null, null);
                break block25;
            }
            HandlerSecurity.injectSecurity(response, ((Platron2PGConnector)this.getConnector()).getConnectorConfiguration().getResultUrl(), secretKey);
            PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, null);
            try {
                XUtil.newTransformer().transform(new DOMSource(response), new StreamResult((OutputStream)res.getOutputStream()));
            }
            catch (Throwable t) {
                res.sendError(500, t.getMessage());
                log.error("response sending failed", t);
            }
        }
        PGInvocationContext.get().end(this.getConnector(), pgLog);
        LogicalStorage.reset();
    }
}

