/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.raiffeisen;

import java.util.Properties;

class Configuration {
    private final boolean traceEnabled;
    private final boolean testEnabled;
    private final String redirectUrl;
    private final String testRedirectUrl;
    private final Long queuePeriod;
    private final double testAmount;

    private static boolean isTrue(String propertyValue) {
        return Boolean.toString(true).equalsIgnoreCase(propertyValue);
    }

    Configuration(Properties data) {
        double test;
        this.traceEnabled = Configuration.isTrue(data.getProperty("trace.enabled"));
        this.testEnabled = Configuration.isTrue(data.getProperty("test.enabled"));
        this.queuePeriod = data.contains("queue.period") ? Long.valueOf(data.getProperty("queue.period")) : null;
        this.redirectUrl = data.getProperty("redirect.url");
        this.testRedirectUrl = data.getProperty("redirect.url.test");
        if (data.getProperty("test.amount") != null) {
            try {
                test = Double.parseDouble(data.getProperty("test.amount"));
            }
            catch (NumberFormatException e) {
                test = 3.0;
            }
        } else {
            test = 3.0;
        }
        this.testAmount = test;
    }

    boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    boolean isTestEnabled() {
        return this.testEnabled;
    }

    boolean isValid() {
        return true;
    }

    Long getQueuePeriod() {
        return this.queuePeriod;
    }

    String getRedirectUrl() {
        return this.redirectUrl;
    }

    String getTestRedirectUrl() {
        return this.testRedirectUrl;
    }

    double getTestAmount() {
        return this.testAmount;
    }
}

