/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.raiffeisen;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.util.TranslitUtil;
import com.gridnine.xtrip.server.pg.raiffeisen.Configuration;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HandlerInitiatePayment {
    protected static final transient Logger log = LoggerFactory.getLogger(HandlerInitiatePayment.class);
    private static final DecimalFormat priceFormatter;

    HandlerInitiatePayment() {
    }

    public static void process(PaymentInitiationResult result, PaymentInitiationParameters parameters, PGParameters pgParameters, Configuration configuration) {
        EntityContainer bfCtr = EntityStorage.get().resolve(result.getPayment().getEntity());
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("PurchaseDesc", TranslitUtil.cyr2lat((String)CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)((Reservation)((BookingFile)bfCtr.getEntity()).getReservations().get(0))), (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.SIRENA)));
        if (configuration.isTestEnabled()) {
            result.getRedirectForm().setUrl(configuration.getTestRedirectUrl());
        } else {
            result.getRedirectForm().setUrl(configuration.getRedirectUrl());
        }
        result.getRedirectForm().setMethod("POST");
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("PurchaseAmt", priceFormatter.format(configuration.isTestEnabled() ? configuration.getTestAmount() : parameters.getPayment().getAmount().doubleValue())));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("Ext1", parameters.getPayment().getPaymentId()));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("CountryCode", "643"));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("CurrencyCode", "643"));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("MerchantName", pgParameters.getPgAccount()));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("MerchantID", pgParameters.getPgPassword()));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("MerchantURL", parameters.getReturnUrl()));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("MerchantCity", "MOSCOW"));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("Language", parameters.getPayment().getCustomerInfo().getPreferredLocale() != null && "ru".equalsIgnoreCase(parameters.getPayment().getCustomerInfo().getPreferredLocale().getLanguage()) ? "ru" : "en"));
    }

    private static NamedValue namedValue(String name, String value) {
        NamedValue nv = new NamedValue();
        nv.setName(name);
        nv.setValue(value);
        return nv;
    }

    static {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        priceFormatter = new DecimalFormat("0.00", dfs);
    }
}

