/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.raiffeisen;

import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGServlet;
import com.gridnine.xtrip.server.pg.PGServletResponse;
import com.gridnine.xtrip.server.pg.raiffeisen.HandlerCompletePayment;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaiffeisenPGServlet
extends PGServlet {
    private static final long serialVersionUID = 9083032265046450896L;
    private static final Logger log = LoggerFactory.getLogger(RaiffeisenPGServlet.class);

    protected PgName getId() {
        return PgName.RAIFFEISEN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) {
        log.debug("service() BEGIN");
        PGInvocationContext.get().begin(InvocationName.SERVLET_SERVICE.toString());
        Date startDate = new Date();
        Map request = PGHelper.convertRequestParametersMap((Map)req.getParameterMap());
        PGServletResponse response = new PGServletResponse(res);
        LinkedList<Message> messages = new LinkedList<Message>();
        LinkedList pgLog = new LinkedList();
        String paymentId = null;
        Payment payment = null;
        try {
            paymentId = req.getParameter("Ext1".toLowerCase());
            if (TextUtil.isBlank((String)paymentId)) {
                throw new Exception("missing parameter '" + "Ext1".toLowerCase() + "'");
            }
            try (NamedLock lock = this.getLock(paymentId);){
                if (!lock.tryLock()) {
                    response.setResponseText("RESP_CODE=-1");
                    response.setResponseCode(200);
                    return;
                }
                try {
                    LogicalStorage.get().authorizeAsSystem();
                    PGInvocationContext.get().setPaymentId(paymentId);
                    payment = this.getFromQueue(paymentId);
                    if (payment == null) {
                        response.setResponseText("RESP_CODE=1");
                        response.setResponseCode(200);
                        return;
                    }
                    HandlerCompletePayment.process(request, payment, messages);
                    RaiffeisenPGServlet.savePaymentStatusTO(payment);
                    if (payment.getStatus() == PaymentStatus.SUCCEEDED) {
                        this.paymentSucceeded(payment, messages);
                        response.setResponseText("RESP_CODE=0");
                        response.setResponseCode(200);
                    } else {
                        if (payment.getStatus() != PaymentStatus.FAILED) throw new Exception("could not determine payment status");
                        this.paymentFailed(payment, messages);
                        response.setResponseText("RESP_CODE=-2");
                        response.setResponseCode(200);
                    }
                    PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, null);
                }
                finally {
                    lock.unlock();
                }
            }
        }
        catch (Throwable t) {
            log.error("service failed", t);
            response.setResponseCode(200);
            response.setResponseText("RESP_CODE=-2");
            PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, t);
        }
        finally {
            PGInvocationContext.get().end(this.getConnector(), pgLog);
            if (payment != null) {
                PGInvocationContext.get().saveDocs(pgLog, messages, payment.getPayee());
            }
            response.send();
            LogicalStorage.reset();
        }
        log.debug("service() END");
    }

    private static void savePaymentStatusTO(Payment payment) throws Exception {
        TemporalObject to = new TemporalObject(payment.getPaymentId());
        to.setExpired(new Date(System.currentTimeMillis() + 900000L));
        to.setTag("RAIFFEISENpaymentStatusTO");
        to.setData(payment.getStatus().name().getBytes());
        LogicalStorage.get().getAssetStorage().save((BaseAsset)to);
    }
}

