/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.rapida;

import com.gridnine.xtrip.common.model.dict.ContractType;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Configuration {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final boolean traceEnabled;
    private final boolean testMode;
    private final Long queuePeriod;
    private final double testAmount;
    private ContractType contractType = ContractType.CLIENT;

    public ContractType getContractType() {
        return this.contractType;
    }

    Configuration(Properties data) {
        double test;
        this.traceEnabled = Configuration.isTrue(data.getProperty("trace.enabled"));
        this.testMode = Configuration.isTrue(data.getProperty("test.enabled"));
        Long l = this.queuePeriod = data.contains("queue.period") ? Long.valueOf(data.getProperty("queue.period")) : null;
        if (data.getProperty("test.amount") != null) {
            try {
                test = Double.parseDouble(data.getProperty("test.amount"));
            }
            catch (NumberFormatException e) {
                test = 1000.0;
            }
        } else {
            test = 1000.0;
        }
        this.testAmount = test;
        try {
            if (data.containsKey("contract.type")) {
                this.contractType = ContractType.valueOf((String)data.getProperty("contract.type"));
            }
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
            this.contractType = ContractType.CLIENT;
        }
    }

    boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    boolean isValid() {
        return true;
    }

    double getTestAmount() {
        return this.testAmount;
    }

    boolean isTest() {
        return this.testMode;
    }

    Long getQueuePeriod() {
        return this.queuePeriod;
    }

    private static boolean isTrue(String propertyValue) {
        return Boolean.toString(true).equalsIgnoreCase(propertyValue);
    }
}

