/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.rapida;

import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.WorkflowStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGServlet;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.rapida.Configuration;
import com.gridnine.xtrip.server.pg.rapida.RapidaPGConnector;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RapidaPGServlet
extends PGServlet {
    private static final long serialVersionUID = 5107482932503807081L;
    private static NumberFormat sumF = new DecimalFormat("#0.00");
    protected final transient Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final List<String> allowedIPs = new ArrayList<String>();

    protected PgName getId() {
        return PgName.RAPIDA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        ValueHolder paymentHolder;
        ArrayList pgLog;
        ArrayList<Message> messages;
        block40: {
            if (this.allowedIPs.isEmpty()) {
                this.allowedIPs.addAll(Arrays.asList(this.getConnector().getConfiguration().getProperty("allowed.ips").split(",")));
            }
            this.log.debug("service() BEGIN");
            httpResponse.setContentType("text/xml");
            PGInvocationContext.get().begin(InvocationName.SERVLET_SERVICE.toString());
            Date startDate = new Date();
            Map request = PGHelper.convertRequestParametersMap((Map)httpRequest.getParameterMap());
            Element response = null;
            messages = new ArrayList<Message>();
            pgLog = new ArrayList();
            String accountId = (String)request.get("account");
            paymentHolder = new ValueHolder();
            try {
                block39: {
                    if (!this.allowedIPs.contains(httpRequest.getRemoteAddr())) {
                        throw new Exception("ip not allowed: " + httpRequest.getRemoteAddr());
                    }
                    LogicalStorage.get().authorizeAsSystem();
                    String command = (String)request.get("command");
                    if ("check".equals(command)) {
                        BigDecimal sum = new BigDecimal((String)request.get("sum"));
                        if (BigDecimal.ZERO.compareTo(sum) == 0) {
                            this.log.debug("command = init");
                            try (NamedLock lock = this.getLock(accountId);){
                                if (!lock.tryLock()) {
                                    throw new Exception("already processing this id");
                                }
                                try {
                                    response = this.init(request, (ValueHolder<Payment>)paymentHolder, messages);
                                    break block39;
                                }
                                finally {
                                    lock.unlock();
                                }
                            }
                        }
                        this.log.debug("command = check");
                        try (NamedLock lock = this.getLock(accountId);){
                            if (!lock.tryLock()) {
                                throw new Exception("already processing this id");
                            }
                            try {
                                response = this.doCheck(request, (ValueHolder<Payment>)paymentHolder, messages);
                                break block39;
                            }
                            finally {
                                lock.unlock();
                            }
                        }
                    }
                    if ("pay".equals(command)) {
                        this.log.debug("command = pay");
                        try (NamedLock lock = this.getLock(accountId);){
                            if (!lock.tryLock()) {
                                throw new Exception("already processing this id");
                            }
                            try {
                                response = this.doPay(request, (ValueHolder<Payment>)paymentHolder, messages);
                                break block39;
                            }
                            finally {
                                lock.unlock();
                            }
                        }
                    }
                    if ("status".equals(command)) {
                        this.log.debug("command = status");
                        response = this.status(request, (ValueHolder<Payment>)paymentHolder, messages);
                    } else {
                        throw new Exception("unknown 'command'");
                    }
                }
                PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, null);
                if (response == null) break block40;
            }
            catch (RapidaException re) {
                block41: {
                    this.log.error("service failed", (Throwable)re);
                    response = RapidaPGServlet.createErrorResponse(re.getCode(), re.getMessage());
                    PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, (Throwable)re);
                    if (response == null) break block41;
                    this.sendResponse(httpResponse, response);
                }
                PGInvocationContext.get().end(this.getConnector(), pgLog);
                if (paymentHolder.getValue() != null) {
                    PGInvocationContext.get().saveDocs(pgLog, messages, ((Payment)paymentHolder.getValue()).getPayee());
                }
                LogicalStorage.reset();
            }
            catch (Throwable t) {
                block42: {
                    this.log.error("service failed", t);
                    response = RapidaPGServlet.createErrorResponse(t);
                    PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, t);
                    if (response == null) break block42;
                    {
                        catch (Throwable throwable) {
                            if (response != null) {
                                this.sendResponse(httpResponse, response);
                            }
                            PGInvocationContext.get().end(this.getConnector(), pgLog);
                            if (paymentHolder.getValue() != null) {
                                PGInvocationContext.get().saveDocs(pgLog, messages, ((Payment)paymentHolder.getValue()).getPayee());
                            }
                            LogicalStorage.reset();
                            throw throwable;
                        }
                    }
                    this.sendResponse(httpResponse, response);
                }
                PGInvocationContext.get().end(this.getConnector(), pgLog);
                if (paymentHolder.getValue() != null) {
                    PGInvocationContext.get().saveDocs(pgLog, messages, ((Payment)paymentHolder.getValue()).getPayee());
                }
                LogicalStorage.reset();
            }
            this.sendResponse(httpResponse, response);
        }
        PGInvocationContext.get().end(this.getConnector(), pgLog);
        if (paymentHolder.getValue() != null) {
            PGInvocationContext.get().saveDocs(pgLog, messages, ((Payment)paymentHolder.getValue()).getPayee());
        }
        LogicalStorage.reset();
        this.log.debug("service() END");
    }

    protected boolean isIssued(EntityContainer<BookingFile> bfCtr) throws Exception {
        for (Reservation res : ((BookingFile)bfCtr.getEntity()).getReservations()) {
            for (BaseProduct bp : res.getProducts()) {
                if (!(bp instanceof Product)) continue;
                return ((Product)bp).getStatus() == ProductStatus.SELL;
            }
        }
        return false;
    }

    private Element status(Map<String, String> request, ValueHolder<Payment> paymentHolder, List<Message> messages) throws Exception {
        MiscUtil.Pair<EntityContainer<BookingFile>, Element> findRes = this.findBookingFile(request.get("account"), false);
        EntityContainer bfCtr = (EntityContainer)findRes.getFirst();
        Element elm = (Element)findRes.getSecond();
        if (bfCtr == null) {
            return elm;
        }
        String result = this.isIssued((EntityContainer<BookingFile>)bfCtr) ? "0" : "1";
        String comment = ((BookingFile)bfCtr.getEntity()).getWorkflowStatus().name();
        return RapidaPGServlet.createErrorResponse(result, comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(HttpServletResponse httpResponse, Element response) throws IOException {
        try {
            httpResponse.getOutputStream().write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes());
            httpResponse.getOutputStream().write(System.getProperty("line.separator").getBytes());
            XUtil.newTransformer().transform(new DOMSource(response), new StreamResult((OutputStream)httpResponse.getOutputStream()));
            httpResponse.getOutputStream().flush();
        }
        catch (Exception ex) {
            this.log.error("error while sending response", (Throwable)ex);
        }
        finally {
            httpResponse.getOutputStream().close();
        }
    }

    protected static Element createErrorResponse(Throwable t) {
        return RapidaPGServlet.createErrorResponse("300", t.getMessage());
    }

    protected static Element createErrorResponse(String code, String text) {
        Element elm = RapidaPGServlet.createResponse();
        XHelper.writeString((Element)elm, (String)"result", (String)code);
        XHelper.writeString((Element)elm, (String)"comment", (String)text);
        return elm;
    }

    protected static Element createSuccessResponse() {
        return RapidaPGServlet.createErrorResponse("0", "ok");
    }

    private static Element createResponse() {
        Document doc = DocumentBuilderHelper.newDocument();
        Element elm = doc.createElement("response");
        doc.appendChild(elm);
        return elm;
    }

    protected MiscUtil.Pair<EntityContainer<BookingFile>, Element> findBookingFile(String bookingNumber, boolean toBePayed) throws Exception {
        if (TextUtil.isBlank((String)bookingNumber) || bookingNumber.length() != 9) {
            return new MiscUtil.Pair(null, (Object)RapidaPGServlet.createErrorResponse("4", "invalid 'account' format"));
        }
        List result = PaymentHelper.searchBookingFile((String)bookingNumber.substring(3, 9), (boolean)toBePayed);
        if (result.size() != 1) {
            return new MiscUtil.Pair(null, (Object)RapidaPGServlet.createErrorResponse("5", "account not found"));
        }
        return new MiscUtil.Pair((Object)EntityStorage.get().resolve(((BookingFileIndex)result.get(0)).getSource()), (Object)RapidaPGServlet.createSuccessResponse());
    }

    protected PaymentType getPaymentType(Map<String, String> request) {
        if ("899544".equals(request.get("user_id"))) {
            return PaymentType.INVOICE_RAPIDA_SVYAZNOY;
        }
        return PaymentType.INVOICE_RAPIDA;
    }

    protected ContractType getContractType() {
        RapidaPGConnector connector = (RapidaPGConnector)this.getConnector();
        return connector.getRapidaConfiguration().getContractType();
    }

    protected String parseAccount(String account) {
        return account;
    }

    private Element init(Map<String, String> request, ValueHolder<Payment> paymentHolder, List<Message> messages) throws Exception {
        String account = request.get("account");
        MiscUtil.Pair<EntityContainer<BookingFile>, Element> findRes = this.findBookingFile(this.parseAccount(account), true);
        EntityContainer bfCtr = (EntityContainer)findRes.getFirst();
        Element elm = (Element)findRes.getSecond();
        if (bfCtr == null) {
            return elm;
        }
        ContractType contractType = this.getContractType();
        PaymentType paymentType = this.getPaymentType(request);
        this.checkForIssuing((EntityContainer<BookingFile>)bfCtr, messages, paymentType);
        Payment payment = PaymentHelper.createPayment((EntityContainer)bfCtr, (PaymentType)paymentType, (ContractType)contractType);
        paymentHolder.setValue((Object)payment);
        String rapidaTransactionId = request.get("txn_id");
        payment.setPaymentId(rapidaTransactionId);
        payment.setPgPaymentId(rapidaTransactionId);
        payment.setPg(PgName.RAPIDA);
        XHelper.writeString((Element)elm, (String)"rapida_txn_id", (String)payment.getPaymentId());
        XHelper.writeString((Element)elm, (String)"account", (String)account);
        XHelper.writeString((Element)elm, (String)"passangers", (String)this.getPassengersInfo((BookingFile)bfCtr.getEntity()));
        XHelper.writeString((Element)elm, (String)"trip", (String)this.getRouteLine((BookingFile)bfCtr.getEntity()));
        XHelper.writeString((Element)elm, (String)"info", (String)this.getInfo((BookingFile)bfCtr.getEntity()));
        Configuration config = new Configuration(this.getConnector().getConfiguration());
        XHelper.writeString((Element)elm, (String)"sum", (String)sumF.format(config.isTest() ? config.getTestAmount() : payment.getAmount().doubleValue()));
        this.paymentInitiated(payment, messages);
        return elm;
    }

    protected void checkForIssuing(EntityContainer<BookingFile> bfCtr, List<Message> messages, PaymentType paymentType) throws Exception {
        PaymentHelper.checkSegmentsForIssuing(bfCtr);
        PaymentHelper.reprice(bfCtr, messages, (PaymentType)paymentType);
    }

    protected String getPassengersInfo(BookingFile bookingFile) {
        Reservation res = BookingHelper.getBaseProductReservation((BookingFile)bookingFile, (boolean)true);
        StringBuilder passangersBldr = new StringBuilder();
        for (BaseProduct bp : res.getProducts()) {
            if (!(bp instanceof Product)) continue;
            Product prod = (Product)bp;
            Traveller trav = prod.getTraveller();
            if (passangersBldr.length() > 0) {
                passangersBldr.append(',');
            }
            passangersBldr.append(trav.getPassport().getLastName());
            passangersBldr.append('/');
            passangersBldr.append(trav.getPassport().getFirstName());
        }
        return passangersBldr.toString();
    }

    protected String getRouteLine(BookingFile bookingFile) {
        Reservation res = BookingHelper.getBaseProductReservation((BookingFile)bookingFile);
        for (BaseProduct bp : res.getProducts()) {
            if (!(bp instanceof Product)) continue;
            Product prod = (Product)bp;
            return AirProductHelper.getLocalizedRouteLine((Product)prod);
        }
        return null;
    }

    private Element doCheck(Map<String, String> request, ValueHolder<Payment> paymentHolder, List<Message> messages) throws Exception {
        BigDecimal authSum;
        MiscUtil.Pair<EntityContainer<BookingFile>, Element> findRes = this.findBookingFile(this.parseAccount(request.get("account")), true);
        EntityContainer bfCtr = (EntityContainer)findRes.getFirst();
        Element elm = (Element)findRes.getSecond();
        if (bfCtr == null) {
            return elm;
        }
        Payment payment = this.getFromQueue(request.get("txn_id"));
        if (payment == null) {
            throw new Exception("already processed this id");
        }
        Element response = this.checkOrderForErrorStatus((EntityContainer<BookingFile>)bfCtr);
        if (response != null) {
            return response;
        }
        Configuration config = new Configuration(this.getConnector().getConfiguration());
        BigDecimal actualPrice = config.isTest() ? new BigDecimal(config.getTestAmount()) : this.getTotalPrice((EntityContainer<BookingFile>)bfCtr, this.getPaymentType(request));
        int diff = actualPrice.compareTo(authSum = new BigDecimal(request.get("sum")));
        if (diff != 0) {
            return RapidaPGServlet.createErrorResponse(diff > 0 ? "241" : "242", String.format("actual price = %s", sumF.format(actualPrice.doubleValue())));
        }
        XHelper.writeString((Element)elm, (String)"rapida_txn_id", (String)payment.getPaymentId());
        return elm;
    }

    protected BigDecimal getTotalPrice(EntityContainer<BookingFile> bfCtr, PaymentType paymentType) throws Exception {
        return (BigDecimal)PaymentHelper.getTotalPrices((EntityReference)bfCtr.toReference(), (ContractType)this.getContractType()).get(paymentType);
    }

    protected boolean isOrderCompleted(EntityContainer<BookingFile> bfCtr) {
        return false;
    }

    private Element doPay(Map<String, String> request, ValueHolder<Payment> paymentHolder, List<Message> messages) throws Exception {
        BigDecimal authSum;
        MiscUtil.Pair<EntityContainer<BookingFile>, Element> findRes = this.findBookingFile(this.parseAccount(request.get("account")), true);
        EntityContainer bfCtr = (EntityContainer)findRes.getFirst();
        Element elm = (Element)findRes.getSecond();
        if (bfCtr == null) {
            return elm;
        }
        Payment payment = this.getFromQueue(request.get("txn_id"));
        if (payment == null) {
            findRes = this.findBookingFile(this.parseAccount(request.get("account")), false);
            bfCtr = (EntityContainer)findRes.getFirst();
            elm = (Element)findRes.getSecond();
            if (bfCtr == null) {
                return elm;
            }
            if (!this.isIssued((EntityContainer<BookingFile>)bfCtr)) {
                return RapidaPGServlet.createErrorResponse("300", "payment not found and booking not issued");
            }
            this.generatePayResponse(elm, request.get("txn_id"), (EntityContainer<BookingFile>)bfCtr);
            return elm;
        }
        Element response = this.checkOrderForErrorStatus((EntityContainer<BookingFile>)bfCtr);
        if (response != null) {
            return response;
        }
        Configuration config = new Configuration(this.getConnector().getConfiguration());
        BigDecimal actualPrice = config.isTest() ? new BigDecimal(config.getTestAmount()) : this.getTotalPrice((EntityContainer<BookingFile>)bfCtr, this.getPaymentType(request));
        int diff = actualPrice.compareTo(authSum = new BigDecimal(request.get("sum")));
        if (diff != 0) {
            return RapidaPGServlet.createErrorResponse(diff > 0 ? "241" : "242", String.format("actual price = %s", sumF.format(actualPrice.doubleValue())));
        }
        try {
            payment.setPaymentDate(new SimpleDateFormat("yyyyMMddHHmmss").parse(request.get("txn_date")));
        }
        catch (Exception e) {
            this.log.error("invalid format payment date", (Throwable)e);
        }
        if (!this.isOrderCompleted((EntityContainer<BookingFile>)bfCtr)) {
            this.paymentSucceeded(payment, messages);
        }
        this.generatePayResponse(elm, payment.getPaymentId(), (EntityContainer<BookingFile>)bfCtr);
        return elm;
    }

    private Element checkOrderForErrorStatus(EntityContainer<BookingFile> bfCtr) {
        if (((BookingFile)bfCtr.getEntity()).getWorkflowStatus() == WorkflowStatus.ERROR) {
            this.log.warn(String.format("BookingFile [%s] couldn't accept pay request, status [ERROR]", ((BookingFile)bfCtr.getEntity()).getNumber()));
            return RapidaPGServlet.createErrorResponse("301", "order has error status");
        }
        return null;
    }

    private void generatePayResponse(Element elm, String txn_id, EntityContainer<BookingFile> bfCtr) {
        XHelper.writeString((Element)elm, (String)"rapida_txn_id", (String)txn_id);
        XHelper.writeString((Element)elm, (String)"prv_txn", (String)txn_id);
        XHelper.writeString((Element)elm, (String)"passangers", (String)this.getPassengersInfo((BookingFile)bfCtr.getEntity()));
        XHelper.writeString((Element)elm, (String)"trip", (String)this.getRouteLine((BookingFile)bfCtr.getEntity()));
        XHelper.writeString((Element)elm, (String)"receipt", (String)this.getReceipt(bfCtr));
    }

    protected String getInfo(BookingFile entity) {
        return null;
    }

    protected String getReceipt(EntityContainer<BookingFile> bfCtr) {
        return null;
    }

    public static class RapidaException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final String code;

        public RapidaException(String code, String message) {
            super(message);
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

