/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.rbs;

import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

class Configuration {
    private final boolean traceEnabled;
    private final String serviceUrl;
    private final String redirectUrl;
    private final boolean testMode;
    private final long checkerDelay;
    private final Long queuePeriod;
    private final Map<InvocationName, String> urlPostfixes = new LinkedHashMap<InvocationName, String>();

    private static boolean isTrue(String propertyValue) {
        return Boolean.toString(true).equalsIgnoreCase(propertyValue);
    }

    Configuration(Properties data) {
        this.traceEnabled = Configuration.isTrue(data.getProperty("trace.enabled"));
        this.serviceUrl = data.getProperty("service.url");
        this.redirectUrl = data.getProperty("redirect.url");
        this.testMode = Configuration.isTrue(data.getProperty("test.mode"));
        this.checkerDelay = data.containsKey("checker.delay") ? Long.parseLong(data.getProperty("checker.delay")) : 60000L;
        this.queuePeriod = data.containsKey("queue.period") ? Long.valueOf(data.getProperty("queue.period")) : null;
        for (Object keyO : data.keySet()) {
            String key = (String)keyO;
            if (!key.startsWith("url.postfix.")) continue;
            this.urlPostfixes.put(InvocationName.valueOf((String)key.substring(12)), data.getProperty(key));
        }
    }

    boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    String getServiceUrl() {
        return this.serviceUrl;
    }

    String getUrlPostfix(InvocationName invocationName) {
        return this.urlPostfixes.get(invocationName);
    }

    String getRedirectUrl() {
        return this.redirectUrl;
    }

    boolean isTestMode() {
        return this.testMode;
    }

    long getCheckerDelay() {
        return this.checkerDelay;
    }

    Long getQueuePeriod() {
        return this.queuePeriod;
    }

    boolean isValid() {
        return !TextUtil.isBlank((String)this.serviceUrl) && !TextUtil.isBlank((String)this.redirectUrl);
    }
}

