/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.rbs;

import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Properties;

class ConfigurationV2 {
    private final boolean traceEnabled;
    private final String serviceUrl;
    private final Long queuePeriod;
    private final long checkerDelay;
    private final long checker3DSecureDelay;

    private static boolean isTrue(String propertyValue) {
        return Boolean.toString(true).equalsIgnoreCase(propertyValue);
    }

    ConfigurationV2(Properties data) {
        this.traceEnabled = ConfigurationV2.isTrue(data.getProperty("trace.enabled"));
        this.serviceUrl = data.getProperty("service.url");
        this.checkerDelay = data.containsKey("checker.delay") ? Long.parseLong(data.getProperty("checker.delay")) : 60000L;
        this.checker3DSecureDelay = data.containsKey("checker.3dsecure.delay") ? Long.parseLong(data.getProperty("checker.3dsecure.delay")) : 1500000L;
        this.queuePeriod = data.containsKey("queue.period") ? Long.valueOf(data.getProperty("queue.period")) : null;
    }

    boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    String getServiceUrl() {
        return this.serviceUrl;
    }

    Long getQueuePeriod() {
        return this.queuePeriod;
    }

    boolean isValid() {
        return !TextUtil.isBlank((String)this.serviceUrl);
    }

    public long getCheckerDelay() {
        return this.checkerDelay;
    }

    public long getChecker3DSecureDelay() {
        return this.checker3DSecureDelay;
    }
}

