/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.rbs;

import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.CardTransactionDetails;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

class HandlerCheckPayment {
    private static final transient Logger log = LoggerFactory.getLogger(HandlerCheckPayment.class);

    HandlerCheckPayment() {
    }

    static Map<String, String> createRequest(PGParameters params, PaymentCheckParameters pcp) {
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        request.put("MDORDER", pcp.getPayment().getPgPaymentId());
        request.put("MERCHANTPASSWD", params.getPgPassword());
        return request;
    }

    static void processRepsonse(Payment payment, Element response, List<Message> messages) throws Exception {
        SimpleDateFormat expiryDf = new SimpleDateFormat("yyyyMM");
        if (!"PSApiResult".equals(response.getNodeName())) {
            throw new PGException("invalid xml response : root element must be 'PSApiResult'");
        }
        int primaryRC = XHelper.readInt((Element)response, (String)"@primaryRC", (int)-1);
        int secondaryRC = XHelper.readInt((Element)response, (String)"@secondaryRC", (int)-1);
        if (primaryRC == 0 && secondaryRC == 0) {
            messages.add(MessageHelper.createMessage((String)"\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u0437\u0430\u043a\u0430\u0437\u0430 \u043f\u0440\u043e\u0448\u043b\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e", (Object[])new Object[0]));
            Element psOrder = XmlUtil.getElement((Element)response, (String)"PSOrder");
            Element psPayment = XmlUtil.getElement((Element)response, (String)"PSOrder/PaymentCollection/PSPayment");
            int authCode = XHelper.readInt((Element)psPayment, (String)"@authCode", (int)-1);
            String pan = XHelper.readString((Element)psOrder, (String)"@PAN");
            String approvalCode = XHelper.readString((Element)psPayment, (String)"@approvalCode");
            String paymentState = XHelper.readString((Element)psPayment, (String)"@payment_state");
            boolean success = !TextUtil.isBlank((String)pan) && !TextUtil.isBlank((String)approvalCode) && !"000000".equals(approvalCode) && "payment_deposited".equalsIgnoreCase(paymentState);
            payment.setStatus(success ? PaymentStatus.SUCCEEDED : PaymentStatus.FAILED);
            messages.add(HandlerCheckPayment.createMessage(authCode));
            if (success) {
                CardTransactionDetails details = new CardTransactionDetails();
                details.setNumber(HandlerCheckPayment.correctMasking(XHelper.readString((Element)psOrder, (String)"@PAN")));
                try {
                    details.setExpiration(expiryDf.parse(XHelper.readString((Element)psOrder, (String)"@expiry")));
                }
                catch (ParseException ex) {
                    log.warn(String.format("error parsing expiry date: %s", XHelper.readString((Element)psOrder, (String)"@expiry")));
                }
                details.setSecurityCode(XHelper.readString((Element)psPayment, (String)"@approvalCode"));
                details.setVendor(PaymentHelper.determineCardVendor((String)details.getNumber()));
                payment.setDetails(details);
                payment.setAmount(new BigDecimal(XHelper.readString((Element)psPayment, (String)"@depositAmount")).movePointLeft(2));
            }
        } else {
            if (primaryRC == 2 && secondaryRC == 204) {
                throw new PGException("\u0417\u0430\u043a\u0430\u0437 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c MDORDER \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
            throw new PGException(String.format("unknown error, primaryRC=%d, secondaryRC=%d", primaryRC, secondaryRC));
        }
    }

    private static String correctMasking(String maskedNumber) {
        if (TextUtil.isBlank((String)maskedNumber)) {
            return maskedNumber;
        }
        if (!HandlerCheckPayment.checkFormat(maskedNumber)) {
            log.warn(String.format("unknown format of masked number %s (returning as is)", maskedNumber));
            return maskedNumber;
        }
        return maskedNumber.substring(0, 6) + "XXXXXX" + maskedNumber.substring(8, 12);
    }

    private static boolean checkFormat(String maskedNumber) {
        if (maskedNumber.length() != 12) {
            return false;
        }
        for (int i = 0; i < 12; ++i) {
            if (!(i >= 0 && i <= 5 || i >= 8 && i <= 12 ? !Character.isDigit(maskedNumber.charAt(i)) : '*' != maskedNumber.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static Message createMessage(int authCode) {
        String text;
        switch (authCode) {
            case 0: {
                text = "\u043f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u043e\u0448\u0435\u043b \u0443\u0441\u043f\u0435\u0448\u043d\u043e";
                break;
            }
            case 1: {
                text = "\u041d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430";
                break;
            }
            case 2: {
                text = "\u043e\u0442\u043a\u043b\u043e\u043d\u0435\u043d \u044d\u043c\u0438\u0442\u0435\u043d\u0442\u043e\u043c";
                break;
            }
            case 3: {
                text = "\u043d\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u043e\u0442\u0432\u0435\u0442 \u043e\u0442 \u044d\u043c\u0438\u0442\u0435\u043d\u0442\u0430";
                break;
            }
            case 4: {
                text = "\u043e\u0448\u0438\u0431\u043a\u0430 \u043d\u0430 \u0441\u0442\u043e\u0440\u043e\u043d\u0435 \u044d\u043c\u0438\u0442\u0435\u043d\u0442\u0430";
                break;
            }
            case 5: {
                text = "\u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u0430 \u0441\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 - \u043d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u0434\u0435\u043d\u0435\u0433";
                break;
            }
            case 6: {
                text = "\u0441\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043a\u0430\u0440\u0442\u044b \u0438\u0441\u0442\u0435\u043a";
                break;
            }
            case 7: {
                text = "\u043f\u043e \u0434\u0430\u043d\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u044b \u0438\u043d\u0442\u0435\u0440\u043d\u0435\u0442 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438";
                break;
            }
            case 8: {
                text = "\u043e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 \u0434\u0430\u043d\u043d\u044b\u0445";
                break;
            }
            case 10: {
                text = "\u0432\u044b \u043f\u0440\u0438\u0441\u043b\u0430\u043b\u0438 \u043f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u044e\u0449\u0438\u0439 \u0432\u0430\u0448\u0438 \u043b\u0438\u043c\u0438\u0442\u044b";
                break;
            }
            case 11: {
                text = "\u043f\u0440\u0438\u0441\u043b\u0430\u043d\u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435 \u043d\u0430 \u043f\u0440\u043e\u0441\u0440\u043e\u0447\u0435\u043d\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436";
                break;
            }
            case 12: 
            case 13: {
                text = "\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u0441 \u0442\u043e\u0447\u043a\u0438 \u0437\u0440\u0435\u043d\u0438\u044f \u044d\u043c\u0438\u0442\u0435\u043d\u0442\u0430";
                break;
            }
            default: {
                text = String.format("unknown @authCode %d", authCode);
            }
        }
        return authCode == 0 ? MessageHelper.createMessage((String)text, (Object[])new Object[0]) : MessageHelper.createErrorMessage((String)text, (Object[])new Object[0]);
    }
}

