/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.rbs;

import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.CardTransactionDetails;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.rbs.ws.OrderStatusExtendedRequest;
import com.gridnine.xtrip.server.pg.rbs.ws.OrderStatusExtendedResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HandlerCheckPaymentV2 {
    private static final transient Logger log = LoggerFactory.getLogger(HandlerCheckPaymentV2.class);

    HandlerCheckPaymentV2() {
    }

    static OrderStatusExtendedRequest createRequest(PGParameters params, PaymentCheckParameters pcp) {
        OrderStatusExtendedRequest request = new OrderStatusExtendedRequest();
        request.setOrderId(pcp.getPayment().getPgPaymentId());
        request.setMerchantOrderNumber(pcp.getPayment().getPaymentId());
        request.setLanguage(pcp.getPayment().getCustomerInfo().getPreferredLocale() != null && "RU".equalsIgnoreCase(pcp.getPayment().getCustomerInfo().getPreferredLocale().getLanguage()) ? "RU" : "EN");
        return request;
    }

    static void processRepsonse(Payment payment, OrderStatusExtendedResponse response, List<Message> messages) throws Exception {
        if (!TextUtil.isBlank((String)response.getErrorCode()) && !"0".equals(response.getErrorCode())) {
            throw new PGException(response.getErrorMessage());
        }
        messages.add(HandlerCheckPaymentV2.createMessageByStatus(response.getOrderStatus()));
        if (response.getOrderStatus() == 0) {
            messages.add(MessageHelper.createMessage((String)response.getActionCodeDescription(), (Object[])new Object[0]));
            payment.setStatus(PaymentStatus.IN_PROGRESS);
            return;
        }
        if (response.getOrderStatus() != 2) {
            payment.setStatus(PaymentStatus.FAILED);
            return;
        }
        messages.add(MessageHelper.createMessage((String)"\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u0437\u0430\u043a\u0430\u0437\u0430 \u043f\u0440\u043e\u0448\u043b\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e", (Object[])new Object[0]));
        boolean success = response.getActionCode() == 0;
        payment.setStatus(success ? PaymentStatus.SUCCEEDED : PaymentStatus.FAILED);
        messages.add(HandlerCheckPaymentV2.createMessageByActionCode(response.getActionCode(), response.getActionCodeDescription()));
        if (success) {
            CardTransactionDetails details = new CardTransactionDetails();
            details.setNumber(HandlerCheckPaymentV2.correctMasking(response.getCardAuthInfo().getMaskedPan()));
            try {
                SimpleDateFormat expiryDf = new SimpleDateFormat("yyyyMM");
                details.setExpiration(expiryDf.parse(response.getCardAuthInfo().getExpiration()));
            }
            catch (ParseException ex) {
                log.warn(String.format("error parsing expiry date: %s", response.getCardAuthInfo().getExpiration()));
            }
            details.setSecurityCode(response.getCardAuthInfo().getApprovalCode());
            details.setVendor(PaymentHelper.determineCardVendor((String)details.getNumber()));
            payment.setDetails(details);
            payment.setAmount(new BigDecimal(response.getAmount()).movePointLeft(2));
        }
    }

    private static String correctMasking(String maskedNumber) {
        if (TextUtil.isBlank((String)maskedNumber)) {
            return maskedNumber;
        }
        if (!HandlerCheckPaymentV2.checkFormat(maskedNumber)) {
            log.warn(String.format("unknown format of masked number %s (returning as is)", maskedNumber));
            return maskedNumber;
        }
        return maskedNumber.substring(0, 6) + "XXXXXX" + maskedNumber.substring(8, 12);
    }

    private static boolean checkFormat(String maskedNumber) {
        if (maskedNumber.length() != 12) {
            return false;
        }
        for (int i = 0; i < 12; ++i) {
            if (!(i >= 0 && i <= 5 || i >= 8 && i <= 12 ? !Character.isDigit(maskedNumber.charAt(i)) : '*' != maskedNumber.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static Message createMessageByActionCode(int actionCode, String actionCodeDescription) {
        return actionCode == 0 ? MessageHelper.createMessage((String)actionCodeDescription, (Object[])new Object[0]) : MessageHelper.createErrorMessage((String)actionCodeDescription, (Object[])new Object[0]);
    }

    private static Message createMessageByStatus(int paymentStatus) {
        String text;
        switch (paymentStatus) {
            case 0: {
                text = "\u0417\u0430\u043a\u0430\u0437 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d, \u043d\u043e \u043d\u0435 \u043e\u043f\u043b\u0430\u0447\u0435\u043d";
                break;
            }
            case 2: {
                text = "\u041f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0430 \u043f\u043e\u043b\u043d\u0430\u044f \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044f \u0441\u0443\u043c\u043c\u044b \u0437\u0430\u043a\u0430\u0437\u0430";
                break;
            }
            case 3: {
                text = "\u0410\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430";
                break;
            }
            case 4: {
                text = "\u041f\u043e \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 \u0431\u044b\u043b\u0430 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430";
                break;
            }
            case 5: {
                text = "\u0418\u043d\u0438\u0446\u0438\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044f \u0447\u0435\u0440\u0435\u0437 ACS \u0431\u0430\u043d\u043a\u0430-\u044d\u043c\u0438\u0442\u0435\u043d\u0442\u0430";
                break;
            }
            case 6: {
                text = "\u0410\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044f \u043e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u0430";
                break;
            }
            default: {
                text = String.format("unknown payment status %d", paymentStatus);
            }
        }
        return paymentStatus == 2 ? MessageHelper.createMessage((String)text, (Object[])new Object[0]) : MessageHelper.createErrorMessage((String)text, (Object[])new Object[0]);
    }
}

