/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.rbs;

import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.rbs.Configuration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import org.w3c.dom.Element;

class HandlerInitiatePayment {
    private static final int ORDERNUMBER_MAX = 999999998;

    HandlerInitiatePayment() {
    }

    static Map<String, String> prepareRequest(PGParameters params, PaymentInitiationParameters pip) throws Exception {
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        request.put("MERCHANTNUMBER", params.getPgAccount());
        request.put("ORDERNUMBER", Integer.toString(new Random().nextInt(999999998) + 1));
        request.put("AMOUNT", Integer.toString(pip.getPayment().getAmount().movePointRight(2).intValue()));
        request.put("BACKURL", pip.getReturnUrl());
        request.put("$ORDERDESCRIPTION", pip.getPayment().getDescription());
        request.put("LANGUAGE", pip.getPayment().getCustomerInfo().getPreferredLocale() != null && "RU".equalsIgnoreCase(pip.getPayment().getCustomerInfo().getPreferredLocale().getLanguage()) ? "RU" : "EN");
        request.put("DEPOSITFLAG", "1");
        request.put("MERCHANTPASSWD", params.getPgPassword());
        request.put("MODE", "2");
        return request;
    }

    static void processRepsonse(PaymentInitiationResult result, Element response, Configuration config) throws Exception {
        if (!"mdorder".equals(response.getNodeName())) {
            throw new PGException("invalid xml response : root element must be 'mdorder'");
        }
        String mdOrder = XHelper.readString((Element)response, (String)".");
        result.getPayment().setPgPaymentId(mdOrder);
        result.getRedirectForm().setUrl(config.getRedirectUrl());
        result.getRedirectForm().setMethod("POST");
        NamedValue nv = new NamedValue();
        nv.setName("MDORDER");
        nv.setValue(mdOrder);
        result.getRedirectForm().getParameters().add(nv);
    }
}

