/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.rbs;

import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.rbs.ISO4217_Numeric;
import com.gridnine.xtrip.server.pg.rbs.ws.OrderParams;
import com.gridnine.xtrip.server.pg.rbs.ws.RegisterOrderResult;

class HandlerInitiatePaymentV2 {
    HandlerInitiatePaymentV2() {
    }

    static OrderParams prepareRequest(PGParameters params, PaymentInitiationParameters pip) throws Exception {
        OrderParams request = new OrderParams();
        Payment payment = pip.getPayment();
        payment.setPaymentId(payment.getPaymentId().replaceAll("-", ""));
        request.setMerchantOrderNumber(payment.getPaymentId());
        request.setClientId(params.getPgAccount());
        request.setAmount(pip.getPayment().getAmount().movePointRight(2).intValue());
        String equiveCurr = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)null);
        request.setCurrency(ISO4217_Numeric.getCurrencyForCode(equiveCurr).getNumericCode());
        request.setReturnUrl(pip.getReturnUrl());
        request.setDescription(pip.getPayment().getDescription());
        request.setLanguage(pip.getPayment().getCustomerInfo().getPreferredLocale() != null && "RU".equalsIgnoreCase(pip.getPayment().getCustomerInfo().getPreferredLocale().getLanguage()) ? "RU" : "EN");
        return request;
    }

    static void processRepsonse(PGParameters params, PaymentInitiationResult result, RegisterOrderResult response) throws Exception {
        if (response.getErrorCode() > 0) {
            throw new PGException(response.getErrorMessage());
        }
        result.getPayment().setPgPaymentId(response.getOrderId());
        result.getRedirectForm().setUrl(response.getFormUrl());
        result.getRedirectForm().setMethod("GET");
        result.getRedirectForm().getParameters().add(NamedValueHelper.namedValue((String)"mdOrder", (String)response.getOrderId()));
    }
}

