/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.rbs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;

public class ISO4217_Numeric {
    private static final HashMap<String, CurrencyWrapper> map = new HashMap();

    public static CurrencyWrapper getCurrencyForCode(String code) {
        return map.get(code);
    }

    static {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(ISO4217_Numeric.class.getResourceAsStream("iso4217_numeric.txt")));
            while ((line = br.readLine()) != null) {
                if (line.trim().length() <= 0 || line.startsWith("#")) continue;
                StringTokenizer st = new StringTokenizer(line, ",");
                String numericCode = st.nextToken();
                String currencyCode = st.nextToken();
                map.put(currencyCode, new CurrencyWrapper(numericCode, currencyCode, st.nextToken()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static class CurrencyWrapper {
        private final String numericCode;
        private final String code;
        private final String displayName;

        CurrencyWrapper(String numericCodeValue, String codeValue, String displayNameValue) {
            this.numericCode = numericCodeValue;
            this.code = codeValue;
            this.displayName = displayNameValue;
        }

        public String getNumericCode() {
            return this.numericCode;
        }

        public String getCode() {
            return this.code;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

