/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.rbs;

import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.PGConnectorInfo;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentCheckResult;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGRulesHelper;
import com.gridnine.xtrip.server.pg.PaymentChecker;
import com.gridnine.xtrip.server.pg.rbs.Configuration;
import com.gridnine.xtrip.server.pg.rbs.HandlerInitiatePayment;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.w3c.dom.Element;

public class RbsPGConnector
extends PGConnector {
    private boolean enabled;
    private boolean disposed;
    private Configuration configuration;
    private Tracer tracer = null;

    public PgName getId() {
        return PgName.RBS;
    }

    protected void configure(PGConnectorRegistry registry) {
        super.configure(registry);
        if (!super.isEnabled()) {
            return;
        }
        this.enabled = true;
        this.configuration = new Configuration(this.getConfiguration());
        if (this.configuration.isTraceEnabled()) {
            this.tracer = PGHelper.createTracer((PgName)this.getId());
        }
        this.enabled = this.configuration.isValid();
        if (this.enabled) {
            this.log.debug("configured");
        } else {
            this.log.warn("invalid configuration, RBS connector disabled");
        }
    }

    public PGConnectorInfo getConnectorInfo() {
        PGConnectorInfo result = new PGConnectorInfo();
        result.setEnabled(this.isEnabled());
        result.setPg(this.getId());
        result.getSupportedPaymentTypes().add(PaymentType.CREDIT_CARD_ONLINE_RBS);
        return result;
    }

    public void dispose() {
        this.disposed = true;
        this.log.debug("disposed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element execute(InvocationName invocationName, Map<String, String> request) throws Exception {
        HttpsURLConnection connection = (HttpsURLConnection)new URL(TextUtil.buildUrl((String)(this.configuration.getServiceUrl() + this.configuration.getUrlPostfix(invocationName)), request, (String)"Cp1251")).openConnection();
        if (this.configuration.isTestMode()) {
            connection.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            });
        }
        connection.setRequestMethod("GET");
        connection.setDoInput(true);
        connection.setUseCaches(false);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (DataInputStream in = new DataInputStream(connection.getInputStream());){
            IoUtil.copyStream((InputStream)in, (OutputStream)out, (int)256);
        }
        try {
            Element element = DocumentBuilderHelper.parse((InputStream)new ByteArrayInputStream(out.toByteArray())).getDocumentElement();
            return element;
        }
        catch (Throwable t) {
            throw new PGException(out.toString());
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaymentInitiationResult initiatePayment(PaymentInitiationParameters parameters) {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
        Payment payment = parameters.getPayment();
        this.doPaymentReprice(payment);
        PGInvocationContext.get().begin(InvocationName.INITIATE_PAYMENT.toString());
        Date startDate = new Date();
        PGInvocationContext.get().setPaymentId(payment.getPaymentId());
        PaymentInitiationResult result = new PaymentInitiationResult();
        Map<String, String> request = null;
        Element response = null;
        try {
            result.setPayment((Payment)XCloneHelper.clone((XCloneable)payment));
            PGParameters pgParameters = PGRulesHelper.getPGParameters((SalesContext)parameters.getSalesContext(), (PgName)parameters.getPg(), (Payment)payment);
            request = HandlerInitiatePayment.prepareRequest(pgParameters, parameters);
            response = this.execute(InvocationName.INITIATE_PAYMENT, request);
            HandlerInitiatePayment.processRepsonse(result, response, this.configuration);
            this.paymentInitiated(result.getPayment(), result.getMessages());
            PaymentChecker.schedule((Payment)result.getPayment(), (SalesContext)parameters.getSalesContext(), (PgName)PgName.RBS);
            result.setSuccess(true);
            result.getMessages().add(MessageHelper.createMessage((String)"\u041f\u043b\u0430\u0442\u0435\u0436 {0} \u0447\u0435\u0440\u0435\u0437 \u0448\u043b\u044e\u0437 \u043e\u043f\u043b\u0430\u0442\u044b {1} \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u043d\u0438\u0446\u0438\u0438\u0440\u043e\u0432\u0430\u043d", (String)result.getPayment().getPaymentId(), (Object[])new Object[]{PgName.RBS}));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), request, (Object)response, null);
            PaymentInitiationResult paymentInitiationResult = result;
            return paymentInitiationResult;
        }
        catch (PGException ex) {
            this.log.error("payment initiation failed", (Throwable)ex);
            this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)ex));
            result.setSuccess(false);
            result.getPayment().setStatus(PaymentStatus.ERROR);
            result.getMessages().add(MessageHelper.createErrorMessage((String)ex.getMessage(), (Object[])new Object[0]));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), request, (Object)response, (Throwable)ex);
            PaymentInitiationResult paymentInitiationResult = result;
            return paymentInitiationResult;
        }
        catch (Throwable t) {
            this.log.error("payment initiation failed", t);
            this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)t));
            result.setSuccess(false);
            result.getPayment().setStatus(PaymentStatus.ERROR);
            result.getMessages().add(MessageHelper.createErrorMessage((String)"\u0412\u043e \u0432\u0440\u0435\u043c\u044f \u0438\u043d\u0438\u0446\u0438\u0430\u0446\u0438\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 {0} \u0447\u0435\u0440\u0435\u0437 \u0448\u043b\u044e\u0437 \u043e\u043f\u043b\u0430\u0442\u044b {1} \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430", (String)payment.getPaymentId(), (Object[])new Object[]{PgName.RBS}));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), request, (Object)response, t);
            PaymentInitiationResult paymentInitiationResult = result;
            return paymentInitiationResult;
        }
        finally {
            PGInvocationContext.get().end((PGConnector)this, result.getPgLog());
        }
    }

    protected Long getQueuePeriod() {
        return this.configuration.getQueuePeriod();
    }

    protected Tracer getTracer() {
        return this.tracer;
    }

    public boolean isEnabled() {
        return super.isEnabled() && this.enabled;
    }

    /*
     * Exception decompiling
     */
    public PaymentCheckResult checkPayment(PaymentCheckParameters parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

