/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.rbs;

import com.gridnine.xtrip.server.pg.rbs.RbsPGv2Connector;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityHandler
implements SOAPHandler<SOAPMessageContext> {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private static String WS_SECEXT = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";

    public boolean handleMessage(SOAPMessageContext msgCtxValue) {
        if (((Boolean)msgCtxValue.get((Object)"javax.xml.ws.handler.message.outbound")).booleanValue()) {
            try {
                SOAPEnvelope envelope = msgCtxValue.getMessage().getSOAPPart().getEnvelope();
                SOAPHeader header = envelope.getHeader();
                if (header == null) {
                    header = envelope.addHeader();
                }
                SOAPElement security = header.addChildElement("Security", "wsse", WS_SECEXT);
                SOAPElement userToken = security.addChildElement("UsernameToken", "wsse");
                userToken.addChildElement("Username", "wsse").addTextNode(RbsPGv2Connector.auth.get().getUser());
                userToken.addChildElement("Password", "wsse").addTextNode(RbsPGv2Connector.auth.get().getPassword());
            }
            catch (Exception ex) {
                this.log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return true;
    }

    public Set<QName> getHeaders() {
        return new HashSet<QName>();
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public void close(MessageContext context) {
    }
}

