/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.rsbank;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.CardTransactionDetails;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.rsbank.RsBankConfiguration;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.rsbank.RsBankHelper;
import com.gridnine.xtrip.server.pg.rsbank.RsBankPGConnector;
import com.gridnine.xtrip.server.pg.rsbank.RsbResponseParser;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerCheckTransaction {
    protected static final Logger log = LoggerFactory.getLogger(HandlerCheckTransaction.class);
    private static final String COMMAND_VALUE = "c";

    public static void process(String transactionId, PGConnector connector, RsBankConfiguration configuration, PGParameters pgParameters, String userIp, Payment payment) throws PGException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        try {
            requestParameters.put("trans_id", transactionId);
            requestParameters.put("client_ip_addr", userIp);
            requestParameters.put("command", COMMAND_VALUE);
            String response = RsBankHelper.executeHttpConnection(requestParameters, configuration, pgParameters, "checkTransaction");
            String resultCode = RsbResponseParser.getFieldValue("RESULT_CODE", response);
            if (log.isTraceEnabled()) {
                log.trace(String.format("Parsed [%s] result code from check response", resultCode));
            }
            if (!"000".equals(resultCode)) {
                throw new PGException("Incorrect transaction code");
            }
            payment.setDetails(HandlerCheckTransaction.getCardDetails(response));
            Message auditMessage = SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)String.format("[%s] successfully checked", transactionId), (Object[])new Object[0]);
            RsBankPGConnector.auditMessage((EntityReference)payment.getEntity(), (Message)auditMessage, (String)"rsbank-check");
        }
        catch (Exception e) {
            PGInvocationContext.get().addTraceData(new Date(), InvocationName.GET_PAYMENT_INFO.toString(), null, null, (Throwable)e);
            String errorMsg = String.format("Transaction [%s] checking failed", transactionId);
            log.error(errorMsg, (Throwable)e);
            Message auditMessage = SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("[%s] check failed [%s]", transactionId, e.toString()), (Object[])new Object[0]);
            RsBankPGConnector.auditMessage((EntityReference)payment.getEntity(), (Message)auditMessage, (String)"rsbank-check");
            throw new PGException("Transaction checking error", (Throwable)e);
        }
    }

    private static CardTransactionDetails getCardDetails(String response) {
        try {
            CardTransactionDetails details = new CardTransactionDetails();
            details.setTransactionCode(RsbResponseParser.getFieldValue("RRN", response));
            String cardNumber = RsbResponseParser.getFieldValue("CARD_NUMBER", response);
            details.setNumber(cardNumber);
            details.setVendor(PaymentHelper.determineCardVendor((String)cardNumber));
            details.setSecurityCode(RsbResponseParser.getFieldValue("APPROVAL_CODE", response));
            return details;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }
}

