/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.rsbank;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.rsbank.RsBankConfiguration;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.rsbank.RsBankHelper;
import com.gridnine.xtrip.server.pg.rsbank.RsBankPGConnector;
import com.gridnine.xtrip.server.pg.rsbank.RsbResponseParser;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerConfirmTransaction {
    protected static final Logger log = LoggerFactory.getLogger(HandlerConfirmTransaction.class);
    private static final String COMMAND_VALUE = "t";

    public static void process(String transactionId, Payment payment, RsBankConfiguration configuration, PGParameters pgParameters, ContractType contractType, String userIp, BookingFile bookingFile) {
        Message message = null;
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        StringBuilder serverResponse = new StringBuilder();
        try {
            requestParameters.put("trans_id", transactionId);
            requestParameters.put("client_ip_addr", userIp);
            requestParameters.put("command", COMMAND_VALUE);
            BigDecimal totalPrice = RsBankHelper.getTotalPrice(payment, configuration, contractType);
            String totalFormatted = String.valueOf(totalPrice.intValueExact());
            requestParameters.put("amount", totalFormatted);
            requestParameters.put("currency", "643");
            String description = String.format("\u0417\u0430\u043a\u0430\u0437 %s", CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)((Reservation)bookingFile.getReservations().get(0))));
            requestParameters.put("description", description);
            String response = RsBankHelper.executeHttpConnection(requestParameters, configuration, pgParameters, "confirmTransaction");
            String resultCode = RsbResponseParser.getFieldValue("RESULT_CODE", response);
            if (log.isTraceEnabled()) {
                log.trace(String.format("Parsed [%s] result code from check response", resultCode));
            }
            if (!"000".equals(resultCode)) {
                throw new PGException("Confirm rsbank transaction");
            }
            message = SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)String.format("[%s] confirmed", transactionId), (Object[])new Object[0]);
        }
        catch (Exception e) {
            PGInvocationContext.get().addTraceData(new Date(), InvocationName.PAYMENT_CONFIRM.toString(), requestParameters, (Object)serverResponse, (Throwable)e);
            log.error("", (Throwable)e);
            message = SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("[%s] confirm failed [%s]", transactionId, e.toString()), (Object[])new Object[0]);
        }
        RsBankPGConnector.auditMessage((EntityReference)payment.getEntity(), (Message)message, (String)"rsbank-confirm");
    }
}

