/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.rsbank;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.RedirectForm;
import com.gridnine.xtrip.common.pg.rsbank.RsBankConfiguration;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.rsbank.RsBankHelper;
import com.gridnine.xtrip.server.pg.rsbank.RsbResponseParser;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HandlerInitiatePayment {
    private static final String COMMAND_VALUE = "a";
    protected static final transient Logger log = LoggerFactory.getLogger(HandlerInitiatePayment.class);

    HandlerInitiatePayment() {
    }

    public static void process(PaymentInitiationResult result, PaymentInitiationParameters paymentInitiationParameters, PGParameters pgParameters, RsBankConfiguration configuration, ContractType contractType, BookingFile bookingFile) throws PGException {
        LinkedHashMap<String, String> requestParameters = new LinkedHashMap<String, String>();
        NamedValue userIp = NamedValueHelper.getNamedValueForName((String)"user.ip", (Collection)paymentInitiationParameters.getCustomParameters());
        requestParameters.put("command", COMMAND_VALUE);
        BigDecimal totalPrice = RsBankHelper.getTotalPrice(paymentInitiationParameters.getPayment(), configuration, contractType);
        String totalFormatted = String.valueOf(totalPrice.intValueExact());
        requestParameters.put("amount", totalFormatted);
        requestParameters.put("currency", "643");
        requestParameters.put("client_ip_addr", userIp.getValue());
        String description = String.format("\u0417\u0430\u043a\u0430\u0437 %s", CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)((Reservation)bookingFile.getReservations().get(0))));
        requestParameters.put("description", description);
        EntityContainer ctr = EntityStorage.get().resolve(paymentInitiationParameters.getSalesContext().getCustomer());
        if (ctr != null && ((Person)ctr.getEntity()).getPreferredLocale() != null) {
            requestParameters.put("language", ((Person)ctr.getEntity()).getPreferredLocale().getLanguage());
        } else {
            requestParameters.put("language", "ru");
        }
        try {
            String response = RsBankHelper.executeHttpConnection(requestParameters, configuration, pgParameters, "initiateTransaction");
            String transactionId = RsbResponseParser.getFieldValue("TRANSACTION_ID", response);
            RedirectForm redirectForm = result.getRedirectForm();
            redirectForm.setMethod("POST");
            redirectForm.setUrl(configuration.getRedirectUrl());
            redirectForm.getParameters().add(HandlerInitiatePayment.namedValue("trans_id", transactionId));
            result.getPayment().setPaymentId(transactionId);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new PGException(e.toString());
        }
    }

    private static NamedValue namedValue(String name, String value) {
        NamedValue nv = new NamedValue();
        nv.setName(name);
        nv.setValue(value);
        return nv;
    }
}

