/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.rsbank;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.rsbank.RsBankConfiguration;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.rsbank.RsBankHelper;
import com.gridnine.xtrip.server.pg.rsbank.RsBankPGConnector;
import com.gridnine.xtrip.server.pg.rsbank.RsbResponseParser;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerRollbackTransaction {
    protected static final Logger log = LoggerFactory.getLogger(HandlerRollbackTransaction.class);
    private static final String COMMAND_VALUE = "r";
    private static final String INVOCATION_NAME = "transactionRollback";

    public static void process(String transactionId, RsBankPGConnector connector, PGParameters pgParameters, RsBankConfiguration configuration, Payment payment) {
        Message message = null;
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        StringBuilder serverResponse = new StringBuilder();
        try {
            requestParameters.put("trans_id", transactionId);
            requestParameters.put("command", COMMAND_VALUE);
            String response = RsBankHelper.executeHttpConnection(requestParameters, configuration, pgParameters, "cancelTransaction");
            String resultCode = RsbResponseParser.getFieldValue("RESULT", response);
            if (!"OK".equals(resultCode)) {
                throw new PGException("Incorrect rollback response");
            }
            message = SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)String.format("[%s] rollbacked", transactionId), (Object[])new Object[0]);
        }
        catch (Exception e) {
            PGInvocationContext.get().addTraceData(new Date(), INVOCATION_NAME, requestParameters, (Object)serverResponse, (Throwable)e);
            log.error("", (Throwable)e);
            message = SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("[%s] rollback failed [%s]", transactionId, e.toString()), (Object[])new Object[0]);
        }
        RsBankPGConnector.auditMessage((EntityReference)payment.getEntity(), (Message)message, (String)"rsbank-rollback");
    }
}

