/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.rsbank;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.pg.rsbank.RsBankConfiguration;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class RsBankHelper {
    private static final Logger log = Logger.getLogger(RsBankHelper.class);

    static BigDecimal getTotalPrice(Payment payment, RsBankConfiguration configuration, ContractType contractType) throws PGException {
        try {
            BigDecimal totalPrice = configuration.isTestingMode() ? BigDecimal.valueOf(configuration.getTestAmount().intValue()) : (BigDecimal)PaymentHelper.getTotalPrices((EntityReference)payment.getEntity(), (ContractType)contractType).get(payment.getPaymentType());
            return totalPrice.multiply(BigDecimal.valueOf(100.0));
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            throw new PGException("Cannot get total price");
        }
    }

    static StringBuilder createParamsString(Map<String, String> paramMap) throws UnsupportedEncodingException {
        StringBuilder params = new StringBuilder();
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (params.length() > 0) {
                params.append("&");
            }
            params.append(key + "=" + URLEncoder.encode(value.trim(), "UTF-8"));
        }
        return params;
    }

    static String executeHttpConnection(Map<String, String> requestParameters, RsBankConfiguration configuration, PGParameters pgParameters, String traceRequestMethod) throws Exception {
        String string;
        URL url = new URL(configuration.getServiceUrl());
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        StringBuilder serverResponse = new StringBuilder();
        DataOutputStream wr = null;
        try {
            StringBuilder params = RsBankHelper.createParamsString(requestParameters);
            connection.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            });
            connection.setSSLSocketFactory(RsBankHelper.getFactory(pgParameters));
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setInstanceFollowRedirects(false);
            connection.setRequestProperty("charset", "utf-8");
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Length", Integer.toString(params.toString().getBytes().length));
            wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(params.toString());
            wr.flush();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            String readLine = in.readLine();
            while (readLine != null) {
                if (serverResponse.length() > 0) {
                    serverResponse.append("\n");
                }
                serverResponse.append(readLine);
                readLine = in.readLine();
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("executeHttpConnection response code = %d, text: %s", connection.getResponseCode(), serverResponse));
            }
            PGInvocationContext.get().addTraceData(new Date(), traceRequestMethod, requestParameters, (Object)("code=" + connection.getResponseCode() + System.getProperty("line.separator") + serverResponse), null);
            if (serverResponse.toString().indexOf("error") > -1) {
                throw new PGException(serverResponse.toString());
            }
            string = serverResponse.toString();
        }
        catch (Exception e) {
            try {
                PGInvocationContext.get().addTraceData(new Date(), traceRequestMethod, null, null, (Throwable)e);
                log.error((Object)"Http connection error", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(wr);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)wr);
        return string;
    }

    private static SSLSocketFactory getFactory(PGParameters pgParameters) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
        String password = pgParameters.getPgPassword();
        KeyStore ks = KeyStore.getInstance("JKS");
        FileInputStream fis = new FileInputStream(pgParameters.getPgAccount());
        ks.load(fis, password.toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(ks, password.toCharArray());
        SSLContext sc = SSLContext.getInstance("TLS");
        TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustFactory.init(ks);
        TrustManager[] trustManagers = trustFactory.getTrustManagers();
        sc.init(kmf.getKeyManagers(), trustManagers, null);
        return sc.getSocketFactory();
    }

    public static RsBankConfiguration getConfiguration() throws Exception {
        String RSBANK_CONFIGURATION_UID = "rsbank-configuration";
        EntityReference settingsRef = new EntityReference("rsbank-configuration", RsBankConfiguration.class, null);
        EntityContainer result = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(settingsRef);
        if (result != null) {
            return (RsBankConfiguration)result.getEntity();
        }
        RsBankConfiguration newConfig = new RsBankConfiguration();
        newConfig.setName("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 Russian Standart Bank");
        newConfig.setType(SystemSettingsType.PG_CONFIGURATION);
        newConfig.setPgName(PgName.RSBANK);
        newConfig.setServiceUrl("https://testsecurepay.rsb.ru:9443/ecomm2/MerchantHandler");
        newConfig.setRedirectUrl("https://testsecurepay.rsb.ru/ecomm2/ClientHandler");
        newConfig.setTestingMode(true);
        EntityContainer container = EntityContainer.create((BaseEntity)newConfig);
        container.setUid("rsbank-configuration");
        container.setCreatedBy("system");
        container.getVersionInfo().setCreatedBy("system");
        EntityStorage.get().save(container, true);
        return newConfig;
    }
}

