/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ruru;

import java.util.Properties;

class Configuration {
    private final boolean traceEnabled;
    private final boolean testMode;
    private final String redirectUrl;
    private final Long queuePeriod;

    private static boolean isTrue(String propertyValue) {
        return Boolean.toString(true).equalsIgnoreCase(propertyValue);
    }

    Configuration(Properties data) {
        this.traceEnabled = Configuration.isTrue(data.getProperty("trace.enabled"));
        this.testMode = Configuration.isTrue(data.getProperty("test.enabled"));
        this.queuePeriod = data.contains("queue.period") ? Long.valueOf(data.getProperty("queue.period")) : null;
        this.redirectUrl = data.getProperty("redirect.url");
    }

    boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    boolean isValid() {
        return true;
    }

    boolean isTest() {
        return this.testMode;
    }

    Long getQueuePeriod() {
        return this.queuePeriod;
    }

    String getRedirectUrl() {
        return this.redirectUrl;
    }
}

