/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ruru;

import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.server.pg.ruru.Configuration;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HandlerInitiatePayment {
    protected static final transient Logger log = LoggerFactory.getLogger(HandlerInitiatePayment.class);
    private static final DecimalFormat priceFormatter;

    HandlerInitiatePayment() {
    }

    public static void process(PaymentInitiationResult result, PaymentInitiationParameters parameters, PGParameters pgParameters, Configuration configuration) {
        result.getRedirectForm().setUrl(configuration.getRedirectUrl());
        result.getRedirectForm().setMethod("GET");
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("amount", priceFormatter.format(HandlerInitiatePayment.getPaymentAmmount(parameters, configuration))));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("order_id", parameters.getPayment().getPaymentId()));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("partner_id", HandlerInitiatePayment.getPartnerId(pgParameters.getPgAccount())));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("service_id", HandlerInitiatePayment.getServiceId(pgParameters.getPgAccount())));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("success_url", parameters.getReturnUrl() + "&status=1"));
        result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("failure_url", parameters.getReturnUrl() + "&status=0"));
        String way = HandlerInitiatePayment.getWay(parameters.getPayment().getPaymentType());
        if (!way.equalsIgnoreCase("")) {
            result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("way", way));
        }
        String sig = priceFormatter.format(HandlerInitiatePayment.getPaymentAmmount(parameters, configuration)) + parameters.getReturnUrl() + "&status=0" + parameters.getPayment().getPaymentId() + HandlerInitiatePayment.getPartnerId(pgParameters.getPgAccount()) + HandlerInitiatePayment.getServiceId(pgParameters.getPgAccount()) + parameters.getReturnUrl() + "&status=1" + way;
        try {
            result.getRedirectForm().getParameters().add(HandlerInitiatePayment.namedValue("signature", HandlerInitiatePayment.getSignature(sig, pgParameters)));
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (Base64.DecodingException e) {
            e.printStackTrace();
        }
    }

    private static String getServiceId(String pgAccount) {
        String[] vals = pgAccount.split(";");
        if (vals.length > 1) {
            return vals[1];
        }
        return "";
    }

    private static String getPartnerId(String pgAccount) {
        String[] vals = pgAccount.split(";");
        if (vals.length > 0) {
            return vals[0];
        }
        return "";
    }

    static String getSignature(String sig, PGParameters pgParameters) throws NoSuchAlgorithmException, InvalidKeyException, Base64.DecodingException {
        return HandlerInitiatePayment.getHMAC(sig, new String(Base64.decode((String)pgParameters.getPgPassword())));
    }

    public static String getHMAC(String string, String key) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance("HmacSHA1");
        SecretKeySpec secret = new SecretKeySpec(key.getBytes(), "HmacSHA1");
        mac.init(secret);
        byte[] digest = mac.doFinal(string.getBytes());
        return Base64.encode((byte[])digest);
    }

    private static double getPaymentAmmount(PaymentInitiationParameters parameters, Configuration config) {
        if (config.isTest()) {
            return 160.0;
        }
        return parameters.getPayment().getAmount().doubleValue();
    }

    private static String getWay(PaymentType paymentType) {
        switch (paymentType) {
            case MOBILE_RURU: {
                return "mobile";
            }
            case CREDIT_CARD_RURU: {
                return "card";
            }
            case WEBMONEY_RURU: {
                return "webMoney";
            }
        }
        return "";
    }

    private static NamedValue namedValue(String name, String value) {
        NamedValue nv = new NamedValue();
        nv.setName(name);
        nv.setValue(value);
        return nv;
    }

    static {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        priceFormatter = new DecimalFormat("0.00", dfs);
    }
}

