/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ruru;

import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.PGConnectorInfo;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentCheckResult;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGRulesHelper;
import com.gridnine.xtrip.server.pg.ruru.Configuration;
import com.gridnine.xtrip.server.pg.ruru.HandlerInitiatePayment;
import java.util.Date;

public class RuruPGConnector
extends PGConnector {
    private boolean enabled;
    private Configuration configuration;
    private Tracer tracer;
    private boolean disposed;

    public PgName getId() {
        return PgName.RURU;
    }

    protected Tracer getTracer() {
        return this.tracer;
    }

    protected void configure(PGConnectorRegistry registry) {
        super.configure(registry);
        if (!super.isEnabled()) {
            return;
        }
        this.enabled = true;
        this.configuration = new Configuration(this.getConfiguration());
        if (this.configuration.isTraceEnabled()) {
            this.tracer = PGHelper.createTracer((PgName)this.getId());
        }
        this.enabled = this.configuration.isValid();
        if (this.enabled) {
            this.log.debug("configured");
        } else {
            this.log.warn("invalid configuration, Ruru connector disabled");
        }
    }

    protected Long getQueuePeriod() {
        return this.configuration.getQueuePeriod();
    }

    public PGConnectorInfo getConnectorInfo() {
        PGConnectorInfo result = new PGConnectorInfo();
        result.setEnabled(this.isEnabled());
        result.setPg(this.getId());
        result.getSupportedPaymentTypes().add(PaymentType.MOBILE_RURU);
        result.getSupportedPaymentTypes().add(PaymentType.CREDIT_CARD_RURU);
        result.getSupportedPaymentTypes().add(PaymentType.WEBMONEY_RURU);
        return result;
    }

    public void dispose() {
        this.disposed = true;
        this.log.debug("disposed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaymentInitiationResult initiatePayment(PaymentInitiationParameters parameters) {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
        Payment payment = parameters.getPayment();
        this.doPaymentReprice(payment);
        PGInvocationContext.get().begin(InvocationName.INITIATE_PAYMENT.toString());
        Date startDate = new Date();
        PGInvocationContext.get().setPaymentId(parameters.getPayment().getPaymentId());
        PaymentInitiationResult result = new PaymentInitiationResult();
        result.setPayment(parameters.getPayment());
        try {
            PGParameters pgParameters = PGRulesHelper.getPGParameters((SalesContext)parameters.getSalesContext(), (PgName)parameters.getPg(), (Payment)payment);
            HandlerInitiatePayment.process(result, parameters, pgParameters, this.configuration);
            this.paymentInitiated(result.getPayment(), result.getMessages());
            result.setSuccess(true);
            result.getMessages().add(MessageHelper.createMessage((String)"\u041f\u043b\u0430\u0442\u0435\u0436 {0} \u0447\u0435\u0440\u0435\u0437 \u0448\u043b\u044e\u0437 \u043e\u043f\u043b\u0430\u0442\u044b {1} \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u043d\u0438\u0446\u0438\u0438\u0440\u043e\u0432\u0430\u043d", (String)result.getPayment().getPaymentId(), (Object[])new Object[]{PgName.RURU}));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), (Object)parameters, (Object)result, null);
            PaymentInitiationResult paymentInitiationResult = result;
            return paymentInitiationResult;
        }
        catch (PGException ex) {
            this.log.error("payment initiation failed", (Throwable)ex);
            this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)ex));
            result.setSuccess(false);
            result.getPayment().setStatus(PaymentStatus.ERROR);
            result.getMessages().add(MessageHelper.createErrorMessage((String)ex.getMessage(), (Object[])new Object[0]));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), (Object)parameters, (Object)result, (Throwable)ex);
            PaymentInitiationResult paymentInitiationResult = result;
            return paymentInitiationResult;
        }
        catch (Throwable t) {
            this.log.error("payment initiation failed", t);
            this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)t));
            result.setSuccess(false);
            result.getPayment().setStatus(PaymentStatus.ERROR);
            result.getMessages().add(MessageHelper.createErrorMessage((String)"\u0412\u043e \u0432\u0440\u0435\u043c\u044f \u0438\u043d\u0438\u0446\u0438\u0430\u0446\u0438\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 {0} \u0447\u0435\u0440\u0435\u0437 \u0448\u043b\u044e\u0437 \u043e\u043f\u043b\u0430\u0442\u044b {1} \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430", (String)payment.getPaymentId(), (Object[])new Object[]{PgName.RURU}));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), (Object)parameters, (Object)result, t);
            PaymentInitiationResult paymentInitiationResult = result;
            return paymentInitiationResult;
        }
        finally {
            PGInvocationContext.get().end((PGConnector)this, result.getPgLog());
        }
    }

    public PaymentCheckResult checkPayment(PaymentCheckParameters parameters) {
        throw new UnsupportedOperationException();
    }

    private void savePaymentStatusTO(Payment payment) throws Exception {
        TemporalObject to = new TemporalObject(payment.getPaymentId());
        to.setExpired(new Date(System.currentTimeMillis() + 900000L));
        to.setTag("RURUpaymentStatusTO");
        to.setData(payment.getStatus().name().getBytes());
        LogicalStorage.get().getAssetStorage().save((BaseAsset)to);
    }

    public boolean isEnabled() {
        return super.isEnabled() && this.enabled;
    }
}

