/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.ruru;

import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGRulesHelper;
import com.gridnine.xtrip.server.pg.PGServlet;
import com.gridnine.xtrip.server.pg.PGServletResponse;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.ruru.HandlerCompletePayment;
import com.gridnine.xtrip.server.pg.ruru.HandlerInitiatePayment;
import java.io.StringWriter;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RuruPGServlet
extends PGServlet {
    private static final long serialVersionUID = 9083032265046450896L;
    private static final Logger log = LoggerFactory.getLogger(RuruPGServlet.class);

    public static String getStringFromDocument(Document doc) throws TransformerException {
        DOMSource domSource = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.transform(domSource, result);
        return writer.toString();
    }

    protected PgName getId() {
        return PgName.RURU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) {
        log.debug("service() BEGIN");
        PGInvocationContext.get().begin(InvocationName.SERVLET_SERVICE.toString());
        Date startDate = new Date();
        Map request = PGHelper.convertRequestParametersMap((Map)req.getParameterMap());
        PGServletResponse response = new PGServletResponse(res);
        LinkedList<Message> messages = new LinkedList<Message>();
        LinkedList pgLog = new LinkedList();
        String paymentId = null;
        Payment payment = null;
        try {
            paymentId = req.getParameter("externalId");
            if (TextUtil.isBlank((String)paymentId)) {
                throw new Exception("missing parameter 'externalId'");
            }
            try (NamedLock lock = this.getLock(paymentId);){
                if (!lock.tryLock()) {
                    response.setResponseCode(500);
                    return;
                }
                try {
                    LogicalStorage.get().authorizeAsSystem();
                    PGInvocationContext.get().setPaymentId(paymentId);
                    payment = this.getFromQueue(paymentId);
                    if (payment == null) {
                        response.setResponseCode(200);
                        return;
                    }
                    PGParameters pgParameters = PGRulesHelper.getPGParameters((SalesContext)PaymentHelper.restoreSalesContext((Payment)payment), (PgName)this.getId(), (Payment)payment);
                    HandlerCompletePayment.process(request, payment, messages);
                    if (payment.getStatus() == PaymentStatus.IN_PROGRESS) {
                        this.paymentInitiated(payment, messages);
                    } else if (payment.getStatus() == PaymentStatus.SUCCEEDED) {
                        this.paymentSucceeded(payment, messages);
                    } else {
                        if (payment.getStatus() != PaymentStatus.FAILED) throw new Exception("could not determine payment status");
                        this.paymentFailed(payment, messages);
                    }
                    response.setResponseCode(200);
                    response.setResponseText(RuruPGServlet.getResponseBody(req.getParameter("amount"), paymentId, req.getParameter("id"), pgParameters));
                    PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, null);
                }
                finally {
                    lock.unlock();
                }
            }
        }
        catch (Throwable t) {
            log.error("service failed", t);
            response.setResponseCode(500);
            response.setResponseText(t.getMessage());
            PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, t);
        }
        finally {
            PGInvocationContext.get().end(this.getConnector(), pgLog);
            if (payment != null) {
                PGInvocationContext.get().saveDocs(pgLog, messages, payment.getPayee());
            }
            response.send();
            LogicalStorage.reset();
        }
        log.debug("service() END");
    }

    private static String getResponseBody(String amount, String pnr, String ruruPaymentId, PGParameters pgParameters) throws ParserConfigurationException, TransformerException, InvalidKeyException, DOMException, NoSuchAlgorithmException, Base64.DecodingException {
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element root = doc.createElementNS("http://ruru.service.provider", "ServiceResponse");
        doc.appendChild(root);
        Element errorcode = doc.createElement("ErrorCode");
        errorcode.setTextContent("0");
        root.appendChild(errorcode);
        Element errordescr = doc.createElement("ErrorDescription");
        errordescr.setTextContent("");
        root.appendChild(errordescr);
        Element sig = doc.createElement("Signature");
        String sigtocode = "0" + amount + pnr + ruruPaymentId;
        sig.setTextContent(HandlerInitiatePayment.getSignature(sigtocode, pgParameters));
        root.appendChild(sig);
        Element wcb = doc.createElement("WillCallback");
        wcb.setTextContent("false");
        root.appendChild(wcb);
        Element rbody = doc.createElement("ResponseBody");
        root.appendChild(rbody);
        Element am = doc.createElement("Amount");
        am.setTextContent(amount);
        rbody.appendChild(am);
        Element extid = doc.createElement("ExternalId");
        extid.setTextContent(pnr);
        rbody.appendChild(extid);
        Element id = doc.createElement("Id");
        id.setTextContent(ruruPaymentId);
        rbody.appendChild(id);
        return RuruPGServlet.getStringFromDocument(doc);
    }
}

