/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.sirena;

import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SirenaPGHelper {
    private static final Logger log = LoggerFactory.getLogger(SirenaPGHelper.class);
    public static final String CONNECTOR_CURRENCY = "RUB";
    public static final String SIRENA_PRODUCT_TYPE_SERVICE = "service";

    public static CardVendor matchCardVendor(String code) {
        if ("VI".equals(code)) {
            return CardVendor.VISA;
        }
        if ("CA".equals(code)) {
            return CardVendor.MASTERCARD;
        }
        if ("JC".equals(code)) {
            return CardVendor.JCB;
        }
        if ("DC".equals(code)) {
            return CardVendor.DINERS_CLUB;
        }
        if ("AX".equals(code)) {
            return CardVendor.AMEX;
        }
        log.warn(String.format("unknown card vendor code '%s'", code));
        return null;
    }

    public static String getErrorText(String code) {
        if ("OK".equals(code)) {
            return "\u0437\u0430\u043f\u0440\u043e\u0441 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e";
        }
        if ("ACCESS DENIED".equals(code)) {
            return "\u0434\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d";
        }
        if ("SYSTEM ERROR".equals(code)) {
            return "\u0441\u0438\u0441\u0442\u0435\u043c\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430, \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0447\u0435\u0440\u0435\u0437 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u0432\u0440\u0435\u043c\u044f";
        }
        if ("FATAL_ERROR".equals(code)) {
            return "\u0444\u0430\u0442\u0430\u043b\u044c\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430, \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043f\u0440\u0435\u043a\u0440\u0430\u0442\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441\u044b \u043f\u043e \u0434\u0430\u043d\u043d\u043e\u043c\u0443 \u0437\u0430\u043a\u0430\u0437\u0443";
        }
        if ("ORDER_ERROR".equals(code)) {
            return "\u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043a\u0430\u0437\u0430";
        }
        if ("INVALID_ORDER".equals(code)) {
            return "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0434\u043b\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0437\u0430\u043a\u0430\u0437";
        }
        log.warn(String.format("unknown error text '%s'", code));
        return "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430";
    }

    public static PaymentStatus matchPaymentStatus(String code) {
        if ("success".equals(code)) {
            return PaymentStatus.SUCCEEDED;
        }
        if ("in_progress".equals(code)) {
            return PaymentStatus.IN_PROGRESS;
        }
        if ("failed".equals(code)) {
            return PaymentStatus.FAILED;
        }
        if ("canceled".equals(code)) {
            return PaymentStatus.FAILED;
        }
        log.warn(String.format("unknown payment status '%s'", code));
        return null;
    }

    public static PaymentStatus matchPaymentStatusV2(String code) {
        if ("acknowledged".equals(code)) {
            return PaymentStatus.SUCCEEDED;
        }
        if ("not_acknowledged".equals(code)) {
            return PaymentStatus.SUCCEEDED;
        }
        if ("in_progress".equals(code)) {
            return PaymentStatus.IN_PROGRESS;
        }
        if ("not_authorized".equals(code)) {
            return PaymentStatus.IN_PROGRESS;
        }
        if ("canceled".equals(code)) {
            return PaymentStatus.FAILED;
        }
        log.warn(String.format("unknown payment status '%s'", code));
        return null;
    }

    public static SalesContext restorePgSalesContext(Payment payment) throws Exception {
        BookingFile bf = (BookingFile)EntityStorage.get().resolve(payment.getEntity()).getEntity();
        Reservation res = (Reservation)bf.getReservations().get(0);
        SalesContext result = new SalesContext();
        result.setAgency(bf.getAgency());
        result.setAgent(res.getBookingAgent());
        result.setClient(bf.getCustomerProfile());
        result.setSalesPoint(res.getSalesPoint());
        result.setSubagency(res.getSubagency());
        return result;
    }

    public static String getOrderItemType(BaseProduct product) {
        if (product instanceof AeroexpressTicket) {
            return "aezh";
        }
        if (SirenaPGHelper.isInsurance(product)) {
            return "insurance";
        }
        if (product instanceof Product) {
            return "airticket";
        }
        if (product instanceof HotelProduct) {
            return "hotel";
        }
        throw new UnsupportedOperationException("unknown product in booking file: " + product.getClass());
    }

    static boolean isInsurance(BaseProduct product) {
        if (product instanceof InsuranceAccident || product instanceof InsuranceTouristic) {
            return true;
        }
        return product.getClass().getSimpleName().contains("Insurance");
    }

    public static String extractServerName(String serviceUrl) throws ParseException {
        Pattern PATTERN = Pattern.compile("//(.*?)(?=/)");
        Matcher m = PATTERN.matcher(serviceUrl);
        if (!m.find()) {
            throw new ParseException("Cannot parse with regexp", 0);
        }
        String result = m.group(1);
        return result;
    }

    public static <T> Element toXMLElement(Class<T> clazz, T report) {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Marshaller mm = jc.createMarshaller();
            mm.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            Document document = SirenaPGHelper.getEmptyDoc();
            mm.marshal((Object)new JAXBElement(new QName("uri", "local"), clazz, report), (Node)document);
            return document.getDocumentElement();
        }
        catch (JAXBException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    private static Document getEmptyDoc() {
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        try {
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            return null;
        }
    }
}

