/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.sirena.v1;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.sirena.SirenaPGHelper;
import com.gridnine.xtrip.server.pg.sirena.ws.Amount;
import com.gridnine.xtrip.server.pg.sirena.ws.CustomerInfo;
import com.gridnine.xtrip.server.pg.sirena.ws.OnlineResult;
import com.gridnine.xtrip.server.pg.sirena.ws.OrderDescription;
import com.gridnine.xtrip.server.pg.sirena.ws.OrderID;
import com.gridnine.xtrip.server.pg.sirena.ws.PostEntry;
import com.gridnine.xtrip.server.pg.sirena.ws.PostEntryArray;
import com.gridnine.xtrip.server.pg.sirena.ws.RegisterOrderPaymentGet;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

@Deprecated
class HandlerInitiatePayment {
    protected static final transient Logger log = LoggerFactory.getLogger(HandlerInitiatePayment.class);
    private static final NumberFormat nf = new DecimalFormat("#0.00");

    HandlerInitiatePayment() {
    }

    static RegisterOrderPaymentGet prepareRequest(PGParameters params, PaymentInitiationParameters pip) throws Exception {
        try {
            EntityContainer bfCtr = EntityStorage.get().resolve(pip.getPayment().getEntity());
            pip.getPayment().setPaymentId(TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bfCtr.getEntity())));
        }
        catch (Throwable t) {
            log.warn("failed to substitute payment id with booking file number", t);
        }
        RegisterOrderPaymentGet request = new RegisterOrderPaymentGet();
        request.setOrder(new OrderID());
        request.getOrder().setShopId(Integer.valueOf(Integer.parseInt(params.getPgAccount().substring(params.getPgAccount().lastIndexOf(47) + 1))));
        request.getOrder().setNumber(pip.getPayment().getPaymentId());
        request.setCost(new Amount());
        request.getCost().setAmount(new Float(pip.getPayment().getAmount().floatValue()));
        request.getCost().setCurrency("RUB");
        request.setCustomer(new CustomerInfo());
        if (pip.getPayment().getEntity() == null || !BookingFile.class.equals((Object)pip.getPayment().getEntity().getType())) {
            throw new UnsupportedOperationException("payment not bound to booking");
        }
        EntityContainer bfCtr = EntityStorage.get().resolve(pip.getPayment().getEntity());
        Reservation reservation = null;
        for (Reservation r : ((BookingFile)bfCtr.getEntity()).getReservations()) {
            if (CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)r) != GdsName.SIRENA) continue;
            reservation = r;
            break;
        }
        if (reservation == null) {
            throw new UnsupportedOperationException("no SIRENA reservation in booking file");
        }
        if (((BookingFile)bfCtr.getEntity()).getCustomer().getPassport() != null) {
            request.getCustomer().setName(((BookingFile)bfCtr.getEntity()).getCustomer().getPassport().getFirstName());
            request.getCustomer().setSurname(((BookingFile)bfCtr.getEntity()).getCustomer().getPassport().getLastName());
        } else {
            request.getCustomer().setName(((BookingFile)bfCtr.getEntity()).getCustomer().getName());
        }
        for (Communication comm : ((BookingFile)bfCtr.getEntity()).getCustomer().getCommunications()) {
            switch (comm.getType()) {
                case HOME_PHONE: {
                    request.getCustomer().setPhone(comm.getSense());
                    break;
                }
                case EMAIL: {
                    request.getCustomer().setEmail(comm.getSense());
                    break;
                }
            }
        }
        request.setDescription(new OrderDescription());
        request.getDescription().setDesc((Object)HandlerInitiatePayment.buildOrderDesc(reservation, pip.getPayment()));
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(reservation.getTimeLimit());
        request.getDescription().setTimelimit(DatatypeFactory.newInstance().newXMLGregorianCalendar(c));
        request.setPostdata(new PostEntryArray());
        request.getPostdata().getPostEntry().add(HandlerInitiatePayment.buildPostEntry("Language", pip.getPayment().getCustomerInfo().getPreferredLocale() != null ? pip.getPayment().getCustomerInfo().getPreferredLocale().getLanguage() : "ru"));
        request.getPostdata().getPostEntry().add(HandlerInitiatePayment.buildPostEntry("ReturnURLOk", pip.getReturnUrl() + "&status=Ok"));
        request.getPostdata().getPostEntry().add(HandlerInitiatePayment.buildPostEntry("ReturnURLFault", pip.getReturnUrl() + "&status=Fault"));
        return request;
    }

    private static PostEntry buildPostEntry(String name, String value) {
        PostEntry entry = new PostEntry();
        entry.setName(name);
        entry.setValue(value);
        return entry;
    }

    private static Element buildOrderDesc(Reservation res, Payment payment) {
        Element desc = DocumentBuilderHelper.newDocument().createElement("desc");
        if (payment.getFee().compareTo(BigDecimal.ZERO) == 0) {
            HandlerInitiatePayment.addTicket(desc, res, payment);
        } else {
            Element pckg = XmlUtil.addElement((Element)desc, (String)"package");
            HandlerInitiatePayment.addTicket(pckg, res, payment);
            Element service = XmlUtil.addElement((Element)pckg, (String)"service");
            Element amount = XmlUtil.addElement((Element)service, (String)"amount");
            amount.setAttribute("currency", "RUB");
            XmlUtil.setValue((Element)amount, (String)nf.format(payment.getFee().doubleValue()));
        }
        return desc;
    }

    private static void addTicket(Element owner, Reservation res, Payment payment) {
        Element airticket = XmlUtil.addElement((Element)owner, (String)"airticket");
        XHelper.writeString((Element)airticket, (String)"host", (String)"sirena");
        XHelper.writeString((Element)airticket, (String)"pnr", (String)CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)res));
        Element amount = XmlUtil.addElement((Element)airticket, (String)"amount");
        amount.setAttribute("currency", "RUB");
        BigDecimal pnrAmount = payment.getAmount().add(payment.getFee().negate());
        XmlUtil.setValue((Element)amount, (String)nf.format(pnrAmount.doubleValue()));
    }

    static void processRepsonse(PaymentInitiationResult result, OnlineResult response) throws Exception {
        String resultCode = response.getResult();
        if (!"OK".equals(resultCode)) {
            throw new PGException(SirenaPGHelper.getErrorText(resultCode));
        }
        result.getPayment().setPgPaymentId(response.getSession());
        result.getRedirectForm().setMethod("GET");
        result.getRedirectForm().setUrl(response.getRedirectUrl());
        NamedValue nv = new NamedValue();
        nv.setName("session");
        nv.setValue(response.getSession());
        result.getRedirectForm().getParameters().add(nv);
    }
}

