/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.sirena.v1;

import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.PGConnectorInfo;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentCheckResult;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.pg.sirena.SirenaV2PgSettings;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGRulesHelper;
import com.gridnine.xtrip.server.pg.sirena.v1.HandlerCheckPayment;
import com.gridnine.xtrip.server.pg.sirena.v1.HandlerInitiatePayment;
import com.gridnine.xtrip.server.pg.sirena.v1.SirenaPGLoggingHandler;
import com.gridnine.xtrip.server.pg.sirena.v2.SirenaV2PgSettingsProvider;
import com.gridnine.xtrip.server.pg.sirena.ws.OnlineResult;
import com.gridnine.xtrip.server.pg.sirena.ws.OrderID;
import com.gridnine.xtrip.server.pg.sirena.ws.Orderpay;
import com.gridnine.xtrip.server.pg.sirena.ws.Orderpay_Service;
import com.gridnine.xtrip.server.pg.sirena.ws.PayResultInfo;
import com.gridnine.xtrip.server.pg.sirena.ws.RegisterOrderPaymentGet;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.namespace.QName;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;

@Deprecated
public class SirenaPGConnector
extends PGConnector {
    private boolean enabled;
    private boolean disposed;
    private Tracer tracer = null;
    private Orderpay orderpay;

    public PgName getId() {
        return PgName.SIRENA;
    }

    protected Tracer getTracer() {
        return this.tracer;
    }

    protected Long getQueuePeriod() {
        return ((SirenaV2PgSettings)new SirenaV2PgSettingsProvider().get()).getQueuePeriod();
    }

    public boolean isEnabled() {
        return super.isEnabled() && this.enabled;
    }

    public PGConnectorInfo getConnectorInfo() {
        PGConnectorInfo result = new PGConnectorInfo();
        result.setEnabled(this.isEnabled());
        result.setPg(this.getId());
        result.getSupportedPaymentTypes().add(PaymentType.CREDIT_CARD_ONLINE_SIRENA);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configure(PGConnectorRegistry registry) {
        super.configure(registry);
        if (!super.isEnabled()) {
            return;
        }
        this.enabled = true;
        SirenaV2PgSettings settings = (SirenaV2PgSettings)new SirenaV2PgSettingsProvider().get();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            URL wsdl = Orderpay_Service.class.getClassLoader().getResource("com/gridnine/xtrip/server/pg/sirena/ws/service.wsdl");
            this.orderpay = new Orderpay_Service(wsdl, new QName("http://www.sirena-travel.ru", "orderpay")).getOrderpay();
            ((BindingProvider)this.orderpay).getRequestContext().put("javax.xml.ws.service.endpoint.address", settings.getServiceOrderUrl());
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        if (settings.isTraceEnabled()) {
            this.tracer = PGHelper.createTracer((PgName)this.getId());
            Binding binding = ((BindingProvider)this.orderpay).getBinding();
            ArrayList<SirenaPGLoggingHandler> handlerList = binding.getHandlerChain();
            if (handlerList == null) {
                handlerList = new ArrayList<SirenaPGLoggingHandler>();
            }
            handlerList.add(new SirenaPGLoggingHandler());
            binding.setHandlerChain(handlerList);
        }
    }

    public void dispose() {
        this.disposed = true;
        this.log.debug("disposed");
    }

    private void authenticate(PGParameters pgParameters) {
        ((BindingProvider)this.orderpay).getRequestContext().put("javax.xml.ws.security.auth.username", pgParameters.getPgAccount().substring(0, pgParameters.getPgAccount().lastIndexOf(47)));
        ((BindingProvider)this.orderpay).getRequestContext().put("javax.xml.ws.security.auth.password", pgParameters.getPgPassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaymentInitiationResult initiatePayment(PaymentInitiationParameters parameters) {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
        Payment payment = parameters.getPayment();
        Date startDate = new Date();
        PaymentInitiationResult result = new PaymentInitiationResult();
        try {
            this.doPaymentReprice(payment);
            PGInvocationContext.get().begin(InvocationName.INITIATE_PAYMENT.toString());
            PGInvocationContext.get().setPaymentId(payment.getPaymentId());
            RegisterOrderPaymentGet request = null;
            OnlineResult response = null;
            PGParameters pgParameters = PGRulesHelper.getPGParameters((SalesContext)parameters.getSalesContext(), (PgName)parameters.getPg(), (Payment)payment);
            request = HandlerInitiatePayment.prepareRequest(pgParameters, parameters);
            this.authenticate(pgParameters);
            response = this.orderpay.registerOrderPaymentGet(request.getOrder(), request.getCost(), request.getCustomer(), request.getDescription(), request.getPostdata());
            result.setPayment((Payment)XCloneHelper.clone((XCloneable)payment));
            HandlerInitiatePayment.processRepsonse(result, response);
            this.paymentInitiated(result.getPayment(), result.getMessages());
            result.setSuccess(true);
            result.getMessages().add(MessageHelper.createMessage((String)"\u041f\u043b\u0430\u0442\u0435\u0436 {0} \u0447\u0435\u0440\u0435\u0437 \u0448\u043b\u044e\u0437 \u043e\u043f\u043b\u0430\u0442\u044b {1} \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u043d\u0438\u0446\u0438\u0438\u0440\u043e\u0432\u0430\u043d", (String)result.getPayment().getPaymentId(), (Object[])new Object[]{PgName.SIRENA}));
            PaymentInitiationResult paymentInitiationResult = result;
            return paymentInitiationResult;
        }
        catch (PGException ex) {
            this.log.error("payment initiation failed", (Throwable)ex);
            this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)ex));
            result.setSuccess(false);
            result.getPayment().setStatus(PaymentStatus.ERROR);
            result.getMessages().add(MessageHelper.createErrorMessage((String)ex.getMessage(), (Object[])new Object[0]));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), (Object)parameters, (Object)result, (Throwable)ex);
            PaymentInitiationResult paymentInitiationResult = result;
            return paymentInitiationResult;
        }
        catch (Throwable t) {
            this.log.error("payment initiation failed", t);
            this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)t));
            result.setSuccess(false);
            result.getPayment().setStatus(PaymentStatus.ERROR);
            result.getMessages().add(MessageHelper.createErrorMessage((String)"\u0412\u043e \u0432\u0440\u0435\u043c\u044f \u0438\u043d\u0438\u0446\u0438\u0430\u0446\u0438\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 {0} \u0447\u0435\u0440\u0435\u0437 \u0448\u043b\u044e\u0437 \u043e\u043f\u043b\u0430\u0442\u044b {1} \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430", (String)payment.getPaymentId(), (Object[])new Object[]{PgName.SIRENA}));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), (Object)parameters, (Object)result, t);
            PaymentInitiationResult paymentInitiationResult = result;
            return paymentInitiationResult;
        }
        finally {
            PGInvocationContext.get().end((PGConnector)this, result.getPgLog());
        }
    }

    public PaymentCheckResult checkPayment(PaymentCheckParameters parameters) {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
        Date startDate = new Date();
        PaymentCheckResult result = new PaymentCheckResult();
        OrderID request = null;
        PayResultInfo response = null;
        try {
            Payment payment = (Payment)XCloneHelper.clone((XCloneable)parameters.getPayment());
            PGParameters pgParameters = PGRulesHelper.getPGParameters((SalesContext)parameters.getSalesContext(), (PgName)parameters.getPg(), (Payment)parameters.getPayment());
            request = HandlerCheckPayment.createRequest(pgParameters, parameters);
            this.authenticate(pgParameters);
            response = this.orderpay.getPayresult(request);
            HandlerCheckPayment.processResponse(payment, response, result.getMessages());
            result.setPaymentStatus(payment.getStatus());
            if (payment.getStatus() == PaymentStatus.SUCCEEDED) {
                this.paymentSucceeded(payment, result.getMessages());
            } else if (payment.getStatus() == PaymentStatus.FAILED) {
                this.paymentFailed(payment, result.getMessages());
            }
            result.getMessages().add(MessageHelper.createMessage((String)"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 {0} \u0447\u0435\u0440\u0435\u0437 \u0448\u043b\u044e\u0437 \u043e\u043f\u043b\u0430\u0442\u044b {1}", (String)parameters.getPayment().getPaymentId(), (Object[])new Object[]{PgName.SIRENA}));
            return result;
        }
        catch (PGException ex) {
            this.log.error("payment check failed", (Throwable)ex);
            this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)ex));
            result.setSuccess(false);
            result.getMessages().add(MessageHelper.createErrorMessage((String)ex.getMessage(), (Object[])new Object[0]));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.CHECK_PAYMENT.toString(), null, null, (Throwable)ex);
            return result;
        }
        catch (Throwable t) {
            this.log.error("payment check failed", t);
            this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)t));
            result.setSuccess(false);
            result.getMessages().add(MessageHelper.createErrorMessage((String)"\u0412\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430 {0} \u0447\u0435\u0440\u0435\u0437 \u0448\u043b\u044e\u0437 \u043e\u043f\u043b\u0430\u0442\u044b {1} \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430", (String)parameters.getPayment().getPaymentId(), (Object[])new Object[]{PgName.SIRENA}));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.CHECK_PAYMENT.toString(), null, null, t);
            return result;
        }
    }
}

