/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.sirena.v2;

import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.CardTransactionDetails;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.sirena.SirenaPGHelper;
import com.gridnine.xtrip.server.pg.sirena.v2.MerchantSettings;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.Document;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.OrderID;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.OrderStatus;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.Payment;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckPayment {
    private static final Logger log = LoggerFactory.getLogger(CheckPayment.class);
    private MerchantSettings merchantSettings;

    public CheckPayment(MerchantSettings merchantSettings) {
        this.merchantSettings = merchantSettings;
    }

    public OrderID createRequest(String bookingNumber) throws Exception {
        OrderID request = new OrderID();
        request.setShopId(this.merchantSettings.getShopId());
        request.setNumber(bookingNumber);
        return request;
    }

    public void processResponse(com.gridnine.xtrip.common.pg.model.Payment payment, OrderStatus response, List<Message> messages) throws Exception {
        if (log.isInfoEnabled()) {
            log.info(String.format("Process payment check status with status [%s]", response.getStatus()));
        }
        payment.setStatus(SirenaPGHelper.matchPaymentStatusV2(response.getStatus()));
        this.checkIfStatusEmpty(payment, response, messages);
        this.saveCardDetails(payment, response);
    }

    private void saveCardDetails(com.gridnine.xtrip.common.pg.model.Payment payment, OrderStatus response) {
        if (!response.getPayments().getPayment().isEmpty() && payment.getStatus() != PaymentStatus.FAILED && ((Payment)response.getPayments().getPayment().get(0)).getDoc() != null) {
            Document doc = ((Payment)response.getPayments().getPayment().get(0)).getDoc();
            CardTransactionDetails ctd = new CardTransactionDetails();
            ctd.setNameOnCard(doc.getHolder());
            ctd.setNumber(doc.getNumber());
            ctd.setSecurityCode(((Payment)response.getPayments().getPayment().get(0)).getAuthcode());
            ctd.setVendor(SirenaPGHelper.matchCardVendor(doc.getCode()));
            payment.setDetails(ctd);
        }
    }

    private void checkIfStatusEmpty(com.gridnine.xtrip.common.pg.model.Payment payment, OrderStatus response, List<Message> messages) throws PGException {
        if (payment.getStatus() == null) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430. \u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441: {0}", (Object[])new Object[]{response.getStatus()}));
            log.warn(String.format("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 %s", response.getStatus()));
            throw new PGException(String.format("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 %s", response.getStatus()));
        }
    }
}

