/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.sirena.v2;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.sirena.SirenaV2PgSettings;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.sirena.v2.CostData;
import com.gridnine.xtrip.server.pg.sirena.v2.InitiatePayment;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCostSupplier
implements Supplier<CostData> {
    private CostData costData;
    private static final Logger log = LoggerFactory.getLogger(InitiatePayment.class);
    private final Collection<Reservation> reservations;
    private final SirenaV2PgSettings settings;

    public DefaultCostSupplier(EntityContainer<BookingFile> bookingFile, Collection<Reservation> reservations, SirenaV2PgSettings settings) {
        this.reservations = reservations;
        this.settings = settings;
        BigDecimal totalPrice = BigDecimal.ZERO;
        BigDecimal feeTotal = BigDecimal.ZERO;
        try {
            totalPrice = (BigDecimal)PaymentHelper.getTotalPrices(bookingFile, reservations, (ContractType)settings.getContractType()).get(PaymentType.CREDIT_CARD_ONLINE_SIRENA);
            feeTotal = this.getTotalFee();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        this.costData = new CostData(feeTotal, totalPrice);
    }

    private BigDecimal getTotalFee() {
        return PaymentHelper.getTotalFee(this.reservations, (ContractType)this.settings.getContractType());
    }

    @Override
    public CostData get() {
        return this.costData;
    }
}

