/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.sirena.v2;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.pg.model.CustomParametersName;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.pg.sirena.SirenaV2PgSettings;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.sirena.SirenaPGHelper;
import com.gridnine.xtrip.server.pg.sirena.v2.CostData;
import com.gridnine.xtrip.server.pg.sirena.v2.DefaultCostSupplier;
import com.gridnine.xtrip.server.pg.sirena.v2.MerchantSettings;
import com.gridnine.xtrip.server.pg.sirena.v2.ServerNameReplacer;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.Amount;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.CustomerInfo;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.OnlineResult;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.OrderID;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.OrderInfo;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.OrderItem;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.OrderItemArray;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.PostEntry;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.PostEntryArray;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.RegisterOnline;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Collection;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.function.Supplier;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitiatePayment {
    private static final ServerNameReplacer hostReplacer = new ServerNameReplacer();
    private static Logger log = LoggerFactory.getLogger(InitiatePayment.class);
    private final MerchantSettings merchantSettings;
    private final SirenaV2PgSettings config;
    private final EntityContainer<BookingFile> bookingFile;
    private final Collection<Reservation> reservations;
    private final PaymentInitiationParameters initParams;
    private Supplier<CostData> costDataSupplier;

    public InitiatePayment(MerchantSettings merchantSettings, SirenaV2PgSettings pgSettings, EntityContainer<BookingFile> bookingFile, PaymentInitiationParameters initParams) {
        this.merchantSettings = merchantSettings;
        this.config = pgSettings;
        this.bookingFile = bookingFile;
        this.initParams = initParams;
        this.reservations = !initParams.getPayment().getReservations().isEmpty() ? PaymentHelper.getReservations(bookingFile, (Collection)initParams.getPayment().getReservations()) : ((BookingFile)bookingFile.getEntity()).getReservations();
        this.costDataSupplier = new DefaultCostSupplier(bookingFile, this.reservations, pgSettings);
    }

    public void setCostDataSupplier(Supplier<CostData> costDataSupplier) {
        this.costDataSupplier = costDataSupplier;
    }

    public RegisterOnline prepareRequest() throws Exception {
        this.updatePaymentId();
        RegisterOnline request = this.createEmptyRequest();
        this.addOrder(request);
        if (this.initParams.getPayment().getEntity() == null || !BookingFile.class.equals((Object)this.initParams.getPayment().getEntity().getType())) {
            throw new UnsupportedOperationException("payment not bound to booking");
        }
        Reservation reservation = this.reservations.stream().min(Comparator.comparing(res -> CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)res) != GdsName.SIRENA)).orElseThrow(() -> Xeption.forDeveloper((String)"No reservations found", (Object[])new Object[0]));
        this.setCustomer(request, ((BookingFile)this.bookingFile.getEntity()).getCustomer());
        this.setDescription(request, reservation);
        this.setCost(request);
        this.addOrderItems(request);
        this.addUserLanguage(request);
        this.addReturnUrls(this.merchantSettings, this.initParams, this.config, this.bookingFile, request);
        return request;
    }

    public void finishInit(PaymentInitiationResult result, OnlineResult response) throws Exception {
        result.getPayment().setPgPaymentId(response.getSession());
        result.getRedirectForm().setMethod("GET");
        result.getRedirectForm().setUrl(this.getRedirectUrl(response));
        this.addSessionParam(result, response);
        result.setSuccess(true);
        result.getMessages().add(MessageHelper.createMessage((String)"\u041f\u043b\u0430\u0442\u0435\u0436 {0} \u0447\u0435\u0440\u0435\u0437 \u0448\u043b\u044e\u0437 \u043e\u043f\u043b\u0430\u0442\u044b {1} \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u043d\u0438\u0446\u0438\u0438\u0440\u043e\u0432\u0430\u043d", (String)result.getPayment().getPaymentId(), (Object[])new Object[]{PgName.SIRENA_V2}));
    }

    private RegisterOnline createEmptyRequest() {
        RegisterOnline request = new RegisterOnline();
        request.setPostdata(new PostEntryArray());
        request.setCustomer(new CustomerInfo());
        request.setOrder(new OrderID());
        return request;
    }

    private void addOrder(RegisterOnline request) {
        request.getOrder().setShopId(this.merchantSettings.getShopId());
        request.getOrder().setNumber(this.initParams.getPayment().getPaymentId());
    }

    private void addUserLanguage(RegisterOnline request) {
        request.getPostdata().getPostEntry().add(this.buildPostEntry("Language", this.initParams.getPayment().getCustomerInfo().getPreferredLocale() != null ? this.initParams.getPayment().getCustomerInfo().getPreferredLocale().getLanguage() : "ru"));
    }

    private void updatePaymentId() {
        this.initParams.getPayment().setPaymentId(TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)this.bookingFile.getEntity())));
    }

    private void setDescription(RegisterOnline request, Reservation reservation) throws DatatypeConfigurationException {
        request.setDescription(new OrderInfo());
        request.getDescription().setDescr(this.buildOrderDesc(reservation));
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(reservation.getTimeLimit());
        request.getDescription().setTimelimit(DatatypeFactory.newInstance().newXMLGregorianCalendar(c));
        request.getDescription().setPaytype("card");
        request.getDescription().setItems(new OrderItemArray());
    }

    private void setCost(RegisterOnline request) {
        CostData costData = this.costDataSupplier.get();
        request.setCost(new Amount());
        request.getCost().setCurrency("RUB");
        request.getCost().setAmount(Float.valueOf(costData.getTotal().floatValue()));
        if (this.isNotZero(costData.getFee())) {
            request.getDescription().getItems().getOrderItem().add(this.newOrderItem(((BookingFile)this.bookingFile.getEntity()).getNumber(), "service", costData.getFee()));
        }
    }

    private boolean isNotZero(BigDecimal feeTotal) {
        return feeTotal.compareTo(BigDecimal.ZERO) != 0;
    }

    private void addReturnUrls(MerchantSettings merchantSettings, PaymentInitiationParameters initiateParams, SirenaV2PgSettings config, EntityContainer<BookingFile> bfCtr, RegisterOnline request) throws ParseException {
        String returnUrl = this.getReturnUrl(merchantSettings, initiateParams);
        request.getPostdata().getPostEntry().add(this.buildPostEntry("ReturnURLOk", returnUrl + "&status=Ok&order_num=" + ((BookingFile)bfCtr.getEntity()).getNumber()));
        request.getPostdata().getPostEntry().add(this.buildPostEntry("ReturnURLFault", returnUrl + "&status=Fault"));
        if (this.showInIframe(merchantSettings, config)) {
            request.getPostdata().getPostEntry().add(this.buildPostEntry("Showcase", "iframe"));
        }
    }

    private boolean showInIframe(MerchantSettings merchantSettings, SirenaV2PgSettings config) {
        return config.isShowInIFrame() || merchantSettings.isShowInIFrame() || this.initParams.getCustomParameters().stream().anyMatch(namedValue -> CustomParametersName.SIRENA_SHOW_IN_IFRAME.name().equals(namedValue.getName()) && Boolean.TRUE.toString().equals(namedValue.getValue()));
    }

    private String getReturnUrl(MerchantSettings merchantSettings, PaymentInitiationParameters pip) throws ParseException {
        String returnUrl = pip.getReturnUrl();
        if (merchantSettings.getRedirectUrl() != null) {
            returnUrl = hostReplacer.replace(returnUrl, merchantSettings.getRedirectUrl());
            log.warn(String.format("Override default return url: from [%s] to [%s]", returnUrl, merchantSettings.getRedirectUrl()));
        }
        return returnUrl;
    }

    private void setCustomer(RegisterOnline request, Customer customer) {
        if (customer.getPassport() != null) {
            StringBuilder sb = new StringBuilder(64);
            sb.append(customer.getPassport().getFirstName());
            sb.append(" ");
            sb.append(customer.getPassport().getLastName());
            request.getCustomer().setName(sb.toString());
        } else {
            request.getCustomer().setName(customer.getName());
        }
        for (Communication comm : customer.getCommunications()) {
            switch (comm.getType()) {
                case HOME_PHONE: 
                case MOBILE: {
                    String phone = TextUtil.nonNullStr((String)comm.getCountryCode()) + TextUtil.nonNullStr((String)comm.getCityCode()) + comm.getSense();
                    request.getCustomer().setPhone(phone);
                    break;
                }
                case EMAIL: {
                    request.getCustomer().setEmail(comm.getSense());
                    break;
                }
            }
        }
    }

    private void addOrderItems(RegisterOnline request) {
        for (Reservation reservation : this.reservations) {
            BigDecimal price = BigDecimal.ZERO;
            String type = null;
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (TextUtil.isBlank(type)) {
                    type = SirenaPGHelper.getOrderItemType(baseProduct);
                }
                price = price.add(this.getOrderItemPrice(baseProduct));
            }
            request.getDescription().getItems().getOrderItem().add(this.newOrderItem(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation), type, price));
        }
    }

    protected BigDecimal getOrderItemPrice(BaseProduct baseProduct) {
        return PaymentHelper.getProductPrice((BaseProduct)baseProduct, (ContractType)ContractType.CLIENT);
    }

    private OrderItem newOrderItem(String number, String type, BigDecimal amountValue) {
        OrderItem item = new OrderItem();
        Amount amount = new Amount();
        if ("airticket".equals(type)) {
            amount.setAmount(Float.valueOf(amountValue.floatValue()));
            item.setClearing("tch");
            item.setHost("sirena");
        } else {
            amount.setAmount(Float.valueOf(amountValue.floatValue()));
        }
        amount.setCurrency("RUB");
        item.setAmount(amount);
        item.setNumber(number);
        item.setTypename(type);
        return item;
    }

    private PostEntry buildPostEntry(String name, String value) {
        PostEntry entry = new PostEntry();
        entry.setName(name);
        entry.setValue(value);
        return entry;
    }

    private String buildOrderDesc(Reservation reservation) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("host = sirena, ");
        sb.append("pnr = ").append(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation));
        return sb.toString();
    }

    private void addSessionParam(PaymentInitiationResult result, OnlineResult response) {
        NamedValue nv = new NamedValue();
        nv.setName("session");
        nv.setValue(response.getSession());
        result.getRedirectForm().getParameters().add(nv);
    }

    private String getRedirectUrl(OnlineResult response) throws ParseException {
        String redirectUrl = response.getRedirectUrl();
        if (this.merchantSettings.getRedirectUrl() != null) {
            String newRedirectUrl = hostReplacer.replace(redirectUrl, this.merchantSettings.getRedirectUrl());
            log.debug(String.format("Override default redirectUrl return url from [%s] to [%s]", redirectUrl, newRedirectUrl));
            redirectUrl = newRedirectUrl;
        }
        return redirectUrl;
    }
}

