/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.sirena.v2;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.util.TextUtil;

public class MerchantSettings {
    private String userName;
    private String password;
    private String serviceUrl;
    private String redirectUrl;
    private Integer shopId;
    private boolean showInIFrame;

    public MerchantSettings(PGParameters params) {
        this.validate(params);
        String[] accounts = params.getPgAccount().split("/");
        this.shopId = Integer.valueOf(accounts[1]);
        if (accounts.length > 2) {
            this.showInIFrame = Boolean.valueOf(accounts[2]);
        }
        this.userName = accounts[0];
        this.password = params.getPgPassword();
        this.serviceUrl = params.getPgServiceUrl() != null ? params.getPgServiceUrl().toString() : null;
        this.redirectUrl = params.getPgRedirectUrl() != null ? params.getPgRedirectUrl().toString() : null;
    }

    public MerchantSettings() {
    }

    public boolean isShowInIFrame() {
        return this.showInIFrame;
    }

    public void setShowInIFrame(boolean showInIFrame) {
        this.showInIFrame = showInIFrame;
    }

    public Integer getShopId() {
        return this.shopId;
    }

    public void setShopId(Integer shopId) {
        this.shopId = shopId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    private void validate(PGParameters params) {
        if (TextUtil.isBlank((String)params.getPgAccount()) || TextUtil.isBlank((String)params.getPgPassword())) {
            throw Xeption.forAdmin((String)"invalid parameters", (Object[])new Object[0]);
        }
        if (params.getPgAccount().indexOf("/") == -1) {
            throw Xeption.forAdmin((String)"invalid parameters", (Object[])new Object[0]);
        }
    }
}

