/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.sirena.v2;

import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.system.CardTransactionDetails;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGWebService;
import com.gridnine.xtrip.server.pg.sirena.SirenaPGHelper;
import com.gridnine.xtrip.server.pg.sirena.notify.ws.v2.Document;
import com.gridnine.xtrip.server.pg.sirena.notify.ws.v2.Error;
import com.gridnine.xtrip.server.pg.sirena.notify.ws.v2.Notify;
import com.gridnine.xtrip.server.pg.sirena.notify.ws.v2.ObjectFactory;
import com.gridnine.xtrip.server.pg.sirena.notify.ws.v2.OrderID;
import com.gridnine.xtrip.server.pg.sirena.notify.ws.v2.PaymentArray;
import java.util.ArrayList;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@HandlerChain(file="handlersv2.xml")
@WebService(name="notify", targetNamespace="http://www.sirena-travel.ru")
@XmlSeeAlso(value={ObjectFactory.class})
public class NotifyImpl
extends PGWebService
implements Notify {
    private static final Logger log = LoggerFactory.getLogger(NotifyImpl.class);
    private static final String OK = "OK";
    private static final String ERROR = "ERROR";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebMethod(action="notify")
    @WebResult(name="retval", targetNamespace="http://www.sirena-travel.ru")
    @RequestWrapper(localName="notify", targetNamespace="http://www.sirena-travel.ru", className="com.gridnine.xtrip.server.pg.sirena.notify.ws.v2.Notify_Type")
    @ResponseWrapper(localName="notifyResponse", targetNamespace="http://www.sirena-travel.ru", className="com.gridnine.xtrip.server.pg.sirena.notify.ws.v2.NotifyResponse")
    public String notify(@WebParam(name="order", targetNamespace="http://www.sirena-travel.ru") OrderID order, @WebParam(name="status", targetNamespace="http://www.sirena-travel.ru") String status, @WebParam(name="shopref", targetNamespace="http://www.sirena-travel.ru") String shopref, @WebParam(name="error", targetNamespace="http://www.sirena-travel.ru") Error error, @WebParam(name="payments", targetNamespace="http://www.sirena-travel.ru") PaymentArray payments) {
        DebugUtil.setThreadName((String)"NotifyImpl-notify");
        try {
            String string = this.service(order, status, payments);
            return string;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String service(OrderID orderId, String orderStatus, PaymentArray payments) {
        PGInvocationContext.get().begin("wsNotifyService");
        String paymentId = orderId.getNumber();
        Payment payment = null;
        try {
            NamedLock lock;
            block20: {
                block19: {
                    String string;
                    LogicalStorage.get().authorizeAsSystem();
                    lock = this.getLock(paymentId);
                    try {
                        if (lock.tryLock()) break block19;
                        log.warn(String.format("payment with id %s is being already processed", paymentId));
                        string = OK;
                    }
                    catch (Throwable throwable) {
                        try {
                            lock.close();
                            throw throwable;
                        }
                        catch (PGException pge) {
                            log.error("payment status failed", (Throwable)pge);
                            log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)pge));
                            String string2 = ERROR;
                            return string2;
                        }
                        catch (Exception ex) {
                            log.error("service failed", (Throwable)ex);
                            log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)ex));
                            String string3 = ERROR;
                            return string3;
                        }
                    }
                    lock.close();
                    return string;
                }
                payment = this.getFromQueue(paymentId);
                if (payment != null) break block20;
                log.warn(String.format("payment with id %s has been already processed", paymentId));
                String string = OK;
                lock.close();
                return string;
            }
            payment.setStatus(SirenaPGHelper.matchPaymentStatusV2(orderStatus));
            if (payment.getStatus() == null) {
                throw new PGException(String.format("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 %s", orderStatus));
            }
            if (!payments.getPayment().isEmpty() && payment.getStatus() != PaymentStatus.FAILED && ((com.gridnine.xtrip.server.pg.sirena.notify.ws.v2.Payment)payments.getPayment().get(0)).getDoc() != null) {
                Document doc = ((com.gridnine.xtrip.server.pg.sirena.notify.ws.v2.Payment)payments.getPayment().get(0)).getDoc();
                CardTransactionDetails ctd = new CardTransactionDetails();
                ctd.setNameOnCard(doc.getHolder());
                ctd.setNumber(doc.getNumber());
                ctd.setSecurityCode(((com.gridnine.xtrip.server.pg.sirena.notify.ws.v2.Payment)payments.getPayment().get(0)).getAuthcode());
                ctd.setVendor(SirenaPGHelper.matchCardVendor(doc.getCode()));
                payment.setDetails(ctd);
            }
            ArrayList messages = new ArrayList();
            if (payment.getStatus() == PaymentStatus.SUCCEEDED) {
                this.paymentSucceeded(payment, messages);
            } else if (payment.getStatus() == PaymentStatus.FAILED) {
                this.paymentFailed(payment, messages);
            }
            String string = OK;
            lock.close();
            return string;
        }
        finally {
            LogicalStorage.reset();
        }
    }

    protected PgName getId() {
        return PgName.SIRENA_V2;
    }
}

