/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.sirena.v2;

import com.gridnine.xtrip.common.pg.sirena.SirenaV2PgSettings;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.sirena.SirenaPGHelper;
import com.gridnine.xtrip.server.pg.sirena.v2.LoggingHandler;
import com.gridnine.xtrip.server.pg.sirena.v2.MerchantSettings;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.Orderv2;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.Orderv2_Service;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderServiceRegistry {
    private static final Logger log = LoggerFactory.getLogger(OrderServiceRegistry.class);
    private final Map<String, Orderv2> pgServiceConnections = new HashMap<String, Orderv2>();
    private SirenaV2PgSettings settings;

    public OrderServiceRegistry(SirenaV2PgSettings settings) {
        this.settings = settings;
        this.addServiceConnection(settings.getServiceOrderUrl(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Orderv2 addServiceConnection(String url, boolean isDefaultAddress) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            Orderv2 newService = this.createNewServiceConnection(url, isDefaultAddress);
            this.pgServiceConnections.put(url, newService);
            Orderv2 orderv2 = newService;
            return orderv2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public synchronized Orderv2 getAuthenticatedServiceConnection(MerchantSettings merchantSettings) {
        Orderv2 connection = this.getServiceConnection(merchantSettings);
        ((BindingProvider)connection).getRequestContext().put("javax.xml.ws.security.auth.username", merchantSettings.getUserName());
        ((BindingProvider)connection).getRequestContext().put("javax.xml.ws.security.auth.password", merchantSettings.getPassword());
        return connection;
    }

    private Orderv2 createNewServiceConnection(String url, boolean isDefaultAddress) {
        URL wsdl = Orderv2_Service.class.getClassLoader().getResource("com/gridnine/xtrip/server/pg/sirena/ws/v2/service.wsdl");
        Orderv2 newService = new Orderv2_Service(wsdl, new QName("http://www.sirena-travel.ru", "orderv2")).getOrderv2();
        this.setConnectionUrl(url, isDefaultAddress, (BindingProvider)newService);
        if (this.settings.isTraceEnabled()) {
            Binding binding = ((BindingProvider)newService).getBinding();
            ArrayList<LoggingHandler> handlerList = binding.getHandlerChain();
            if (handlerList == null) {
                handlerList = new ArrayList<LoggingHandler>();
            }
            handlerList.add(new LoggingHandler());
            binding.setHandlerChain(handlerList);
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("A new sirena PgService was registred with url [%s]", url));
        }
        return newService;
    }

    private void setConnectionUrl(String url, boolean isDefaultAddress, BindingProvider newService) {
        Map requestContext = newService.getRequestContext();
        requestContext.put("javax.xml.ws.service.endpoint.address", url);
        if (!isDefaultAddress) {
            requestContext.put("com.sun.xml.ws.transport.https.client.hostname.verifier", (urlHostName, session) -> true);
            try {
                String hostName = SirenaPGHelper.extractServerName(url);
                HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
                headers.put("Host", Collections.singletonList(hostName));
                requestContext.put("javax.xml.ws.http.request.headers", headers);
            }
            catch (ParseException e) {
                log.error("Cannot parse server name from serviceUrl " + this.settings.getServiceOrderUrl());
            }
        }
    }

    private synchronized Orderv2 getServiceConnection(MerchantSettings merchantSettings) {
        Orderv2 result;
        String paramName = "service.url";
        String isFromConfig = "is.default.address.from.config";
        HashMap<String, String> logData = new HashMap<String, String>();
        if (this.isCustomServiceUrlSet(merchantSettings)) {
            String serviceUrl = merchantSettings.getServiceUrl();
            result = this.pgServiceConnections.get(serviceUrl);
            if (result == null) {
                result = this.addServiceConnection(serviceUrl, false);
            }
            logData.put("service.url", serviceUrl);
            logData.put("is.default.address.from.config", "false");
        } else {
            result = this.pgServiceConnections.get(this.settings.getServiceOrderUrl());
            logData.put("service.url", this.settings.getServiceOrderUrl());
            logData.put("is.default.address.from.config", "true");
        }
        PGInvocationContext.get().addTraceData(new Date(), "service.url", logData, null, null);
        return result;
    }

    private boolean isCustomServiceUrlSet(MerchantSettings merchantSettings) {
        return merchantSettings.getServiceUrl() != null;
    }
}

