/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.sirena.v2;

import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.sirena.SirenaPGHelper;
import com.gridnine.xtrip.server.pg.sirena.v2.MerchantSettings;
import com.gridnine.xtrip.server.pg.sirena.v2.SirenaPGv2Connector;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.Amount;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.OrderID;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.OrderStatus;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.Orderv2;
import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefundPayment {
    private static final String SIRENA_REFUNDED_STATUS = "refunded";
    protected static final Logger log = LoggerFactory.getLogger(RefundPayment.class);

    static boolean refund(SirenaPGv2Connector connector, MerchantSettings pgParameters, Date startDate, OrderID orderId, String paymentId, BigDecimal sumToRefund) {
        if (log.isInfoEnabled()) {
            log.info(String.format("SirenaV2 refund, bookingNumberId [%s], paymentId [%s], sum [%.2f]", orderId.getNumber(), paymentId, sumToRefund));
        }
        Orderv2 serviceObj = connector.getServiceRegistry().getAuthenticatedServiceConnection(pgParameters);
        Amount amount = new Amount();
        amount.setAmount(new Float(sumToRefund.floatValue()));
        amount.setCurrency("RUB");
        Random rnd = new Random(System.currentTimeMillis());
        String tnxId = String.valueOf(Math.abs(rnd.nextInt(Integer.MAX_VALUE)));
        OrderStatus refund = serviceObj.refund(orderId, paymentId, amount, tnxId);
        LinkedHashMap<String, String> requestParameters = new LinkedHashMap<String, String>();
        requestParameters.put("shopId", orderId.getShopId().toString());
        requestParameters.put("number", orderId.getNumber());
        requestParameters.put("paymentId", paymentId);
        requestParameters.put("amount", amount.toString());
        requestParameters.put("refundId", tnxId);
        PGInvocationContext.get().addTraceData(startDate, InvocationName.PAYMENT_REFUND.toString(), requestParameters, (Object)SirenaPGHelper.toXMLElement(OrderStatus.class, refund), null);
        return RefundPayment.isSuccessfulResponse(refund);
    }

    private static boolean isSuccessfulResponse(OrderStatus response) {
        String responseStatus = response.getStatus();
        if (log.isInfoEnabled()) {
            log.info(String.format("Process payment refund with status [%s]", response.getStatus()));
        }
        if (SIRENA_REFUNDED_STATUS.equals(responseStatus)) {
            return true;
        }
        log.error(String.format("Sirena refund error, bookingFile [%s], status [%s], error code [%s]", response.getOrder().getNumber(), response.getStatus(), response.getError().getCode()));
        return false;
    }
}

