/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.sirena.v2;

import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerNameReplacer {
    private static final Pattern pattern = Pattern.compile("^(\\w*://[\\w.:-]*)/");
    private static Logger log = LoggerFactory.getLogger(ServerNameReplacer.class);

    public String replace(String url, String newServerName) throws ParseException {
        Matcher matcher = pattern.matcher(url);
        if (!matcher.find()) {
            log.warn("replace server name error {} in {}", (Object)newServerName, (Object)url);
            throw new ParseException("Cannot parse with regexp url " + url, 0);
        }
        return url.replaceAll(matcher.group(1), newServerName);
    }
}

