/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.sirena.v2;

import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.pg.SplitPaymentSupport;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.PGConnectorInfo;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentCheckResult;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.pg.sirena.SirenaV2PgSettings;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGRulesHelper;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.sirena.SirenaPGHelper;
import com.gridnine.xtrip.server.pg.sirena.v2.CheckPayment;
import com.gridnine.xtrip.server.pg.sirena.v2.DefaultHandlerFactory;
import com.gridnine.xtrip.server.pg.sirena.v2.ExceptionTranslator;
import com.gridnine.xtrip.server.pg.sirena.v2.HandlerFactory;
import com.gridnine.xtrip.server.pg.sirena.v2.InitiatePayment;
import com.gridnine.xtrip.server.pg.sirena.v2.MerchantSettings;
import com.gridnine.xtrip.server.pg.sirena.v2.OrderServiceRegistry;
import com.gridnine.xtrip.server.pg.sirena.v2.RefundPayment;
import com.gridnine.xtrip.server.pg.sirena.v2.SirenaV2PgSettingsProvider;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.OnlineResult;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.OrderID;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.OrderStatus;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.Orderv2;
import com.gridnine.xtrip.server.pg.sirena.ws.v2.RegisterOnline;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SirenaPGv2Connector
extends PGConnector
implements SplitPaymentSupport {
    private boolean enabled;
    private boolean disposed;
    private Tracer tracer = null;
    private OrderServiceRegistry serviceRegistry;
    private HandlerFactory handlerFactory = new DefaultHandlerFactory();

    public OrderServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public void setServiceRegistry(OrderServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setHandlerFactory(HandlerFactory handlerFactory) {
        this.handlerFactory = handlerFactory;
    }

    public PgName getId() {
        return PgName.SIRENA_V2;
    }

    public boolean isEnabled() {
        return super.isEnabled() && this.enabled;
    }

    public PGConnectorInfo getConnectorInfo() {
        PGConnectorInfo result = new PGConnectorInfo();
        result.setEnabled(this.isEnabled());
        result.setPg(this.getId());
        result.getSupportedPaymentTypes().add(PaymentType.CREDIT_CARD_ONLINE_SIRENA);
        result.getSupportedPaymentTypes().add(PaymentType.CREDIT_CARD_AGENCY_SIRENA);
        result.getSupportedPaymentTypes().add(PaymentType.CREDIT_CARD_SUPPLIER_SIRENA);
        return result;
    }

    public void configure(PGConnectorRegistry registry) {
        super.configure(registry);
        if (!super.isEnabled()) {
            return;
        }
        this.enabled = true;
        SirenaV2PgSettings settings = (SirenaV2PgSettings)new SirenaV2PgSettingsProvider().get();
        if (settings.isTraceEnabled()) {
            this.tracer = PGHelper.createTracer((PgName)this.getId());
        }
        this.serviceRegistry = new OrderServiceRegistry(settings);
    }

    public void dispose() {
        this.disposed = true;
        this.log.debug("disposed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaymentInitiationResult initiatePayment(PaymentInitiationParameters initParams) {
        this.checkDisposedState();
        PGInvocationContext.get().begin(InvocationName.INITIATE_PAYMENT.toString());
        PGInvocationContext.get().setPaymentId(initParams.getPayment().getPaymentId());
        PaymentInitiationResult result = this.createInitResult(initParams);
        try {
            if (!initParams.isDontDoReprice()) {
                this.doPaymentReprice(initParams.getPayment());
            }
            MerchantSettings merchantSettings = this.createMerchantSettings(this.getPgParametersSupplier().get(initParams.getSalesContext(), initParams.getPg(), initParams.getPayment()));
            EntityContainer bookingFile = EntityStorage.get().resolve(initParams.getPayment().getEntity());
            InitiatePayment initiatePayment = this.handlerFactory.createInitiateHandler(merchantSettings, (SirenaV2PgSettings)new SirenaV2PgSettingsProvider().get(), (EntityContainer<BookingFile>)bookingFile, initParams);
            RegisterOnline request = initiatePayment.prepareRequest();
            OnlineResult webServiceResponse = this.serviceRegistry.getAuthenticatedServiceConnection(merchantSettings).registerOnline(request.getOrder(), request.getCost(), request.getCustomer(), request.getDescription(), request.getPostdata());
            initiatePayment.finishInit(result, webServiceResponse);
            this.paymentInitiated(result.getPayment(), result.getMessages());
        }
        catch (Exception ex) {
            this.handleInitiatePaymentException(result, ex);
        }
        finally {
            PGInvocationContext.get().end((PGConnector)this, result.getPgLog());
        }
        return result;
    }

    private PaymentInitiationResult createInitResult(PaymentInitiationParameters initParams) {
        PaymentInitiationResult result = new PaymentInitiationResult();
        result.setPayment(initParams.getPayment());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaymentCheckResult checkPayment(PaymentCheckParameters parameters) {
        this.checkDisposedState();
        if (this.log.isInfoEnabled()) {
            this.log.info(String.format("Payment checking [paymentId=%s]", parameters.getPayment().getPaymentId()));
        }
        Date startDate = new Date();
        PaymentCheckResult result = new PaymentCheckResult();
        PGInvocationContext.get().begin(InvocationName.CHECK_PAYMENT.toString());
        try {
            Payment clonedPayment = (Payment)XCloneHelper.clone((XCloneable)parameters.getPayment());
            MerchantSettings merchantSettings = this.createMerchantSettings(this.getPgParametersSupplier().get(parameters.getSalesContext(), parameters.getPg(), parameters.getPayment()));
            CheckPayment checkHandler = this.handlerFactory.createCheckHandler(merchantSettings);
            OrderID request = checkHandler.createRequest(parameters.getPayment().getPaymentId());
            OrderStatus response = this.serviceRegistry.getAuthenticatedServiceConnection(merchantSettings).getStatus(request);
            PGInvocationContext.get().addTraceData(startDate, InvocationName.CHECK_PAYMENT.toString(), (Object)SirenaPGHelper.toXMLElement(OrderID.class, request), (Object)SirenaPGHelper.toXMLElement(OrderStatus.class, response), null);
            checkHandler.processResponse(clonedPayment, response, result.getMessages());
            result.setPaymentStatus(clonedPayment.getStatus());
            if (clonedPayment.getStatus() == PaymentStatus.SUCCEEDED) {
                this.doPaymentSucceeded(result, clonedPayment);
            } else if (clonedPayment.getStatus() == PaymentStatus.FAILED) {
                this.doPaymentFailed(result, clonedPayment);
            }
            result.getMessages().add(MessageHelper.createMessage((String)"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 {0} \u0447\u0435\u0440\u0435\u0437 \u0448\u043b\u044e\u0437 \u043e\u043f\u043b\u0430\u0442\u044b {1}", (String)parameters.getPayment().getPaymentId(), (Object[])new Object[]{PgName.SIRENA_V2}));
            PaymentCheckResult paymentCheckResult = result;
            return paymentCheckResult;
        }
        catch (Exception ex) {
            this.handleCheckException(startDate, result, ex);
            PaymentCheckResult paymentCheckResult = result;
            return paymentCheckResult;
        }
        finally {
            PGInvocationContext.get().end((PGConnector)this, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refund(EntityContainer<BookingFile> bfCtr, List<BaseProduct> products, List<Product> feeProducts) {
        SirenaV2PgSettings settings = (SirenaV2PgSettings)new SirenaV2PgSettingsProvider().get();
        this.checkDisposedState();
        PGInvocationContext.get().begin(InvocationName.PAYMENT_REFUND.toString());
        Date transactionLogDate = new Date();
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bfCtr.getEntity()));
        if (this.log.isInfoEnabled()) {
            this.log.info(String.format("Start SirenaV2 refund for booking file [%s]", bookingNumber));
        }
        PGInvocationContext.get().setPaymentId(bookingNumber);
        try {
            SalesContext salesContext = PaymentHelper.restoreSalesContext(bfCtr);
            MerchantSettings merchantSettings = this.createMerchantSettings(PGRulesHelper.getPGParameters((SalesContext)salesContext, (PgName)this.getId(), (Payment)new Payment()));
            BigDecimal productsSumToRefund = PaymentHelper.calculateSumToRefund(products);
            BigDecimal feeSumToRefund = BigDecimal.ZERO;
            if (this.log.isTraceEnabled()) {
                this.log.trace(String.format("Booking file [%s], product sums to refund [%.2f]", bookingNumber, productsSumToRefund));
            }
            if (feeProducts.size() > 0) {
                feeSumToRefund = PaymentHelper.getProductsFeeSum(feeProducts, (ContractType)settings.getContractType());
                if (this.log.isTraceEnabled()) {
                    this.log.trace(String.format("Booking file [%s], fee to refund [%.2f]", bookingNumber, feeSumToRefund));
                }
            }
            BigDecimal totalSumToRefund = productsSumToRefund.add(feeSumToRefund);
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("Booking file [%s], Total sum to refund [%.2f]", bookingNumber, totalSumToRefund));
            }
            if (totalSumToRefund.compareTo(BigDecimal.ZERO) > 0) {
                CheckPayment checkHandler = this.handlerFactory.createCheckHandler(merchantSettings);
                OrderID orderId = checkHandler.createRequest(bookingNumber);
                List<com.gridnine.xtrip.server.pg.sirena.ws.v2.Payment> paymentsInfo = this.getPaymentsInfo(merchantSettings, bookingNumber, transactionLogDate);
                if (paymentsInfo == null || paymentsInfo.size() == 0) {
                    this.log.error("Cannot get information about payments -> terminate refund");
                    boolean bl = false;
                    return bl;
                }
                String BSP_CLEARING_TYPE = "bsp";
                String TCH_CLEARING_TYPE = "tch";
                String PAY_TYPE = "card";
                String sirenaPaymentId = null;
                for (com.gridnine.xtrip.server.pg.sirena.ws.v2.Payment payment : paymentsInfo) {
                    String type = payment.getType();
                    String clearing = payment.getClearing();
                    if (!"card".equals(type) || "bsp".equals(clearing) || "tch".equals(clearing)) continue;
                    sirenaPaymentId = payment.getId();
                    break;
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace(String.format("Refund Booking file [%s], sirenaPaymentId [%s]", bookingNumber, sirenaPaymentId));
                }
                if (TextUtil.isBlank(sirenaPaymentId)) {
                    this.log.error(String.format("Refund Booking file [%s], proper sirenaPaymentId isn't found", bookingNumber));
                    boolean bl = false;
                    return bl;
                }
                boolean bl = RefundPayment.refund(this, merchantSettings, transactionLogDate, orderId, sirenaPaymentId, totalSumToRefund);
                return bl;
            }
            this.log.error(String.format("Booking file [%s], SumToRefund [%.2f] is less or equal to zero", bookingNumber, totalSumToRefund));
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            this.log.error("", (Throwable)ex);
            PGInvocationContext.get().addTraceData(transactionLogDate, InvocationName.PAYMENT_REFUND.toString(), null, null, (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            PGInvocationContext.get().end((PGConnector)this, null);
        }
    }

    public PaymentType getSplitSupplierPaymentType() {
        return PaymentType.CREDIT_CARD_SUPPLIER_SIRENA;
    }

    public PaymentType getSplitAgencyPaymentType() {
        return PaymentType.CREDIT_CARD_AGENCY_SIRENA;
    }

    public PaymentType getSplitMainPaymentType() {
        return PaymentType.CREDIT_CARD_ONLINE_SIRENA;
    }

    public boolean canUseSplitScheme(EntityContainer<BookingFile> bfCtr) {
        return true;
    }

    public boolean canUseSplitScheme(Collection<Reservation> reservations) {
        return true;
    }

    protected Tracer getTracer() {
        return this.tracer;
    }

    protected Long getQueuePeriod() {
        return ((SirenaV2PgSettings)new SirenaV2PgSettingsProvider().get()).getQueuePeriod();
    }

    private MerchantSettings createMerchantSettings(PGParameters pgParameters) throws Exception {
        return new MerchantSettings(pgParameters);
    }

    private void handleInitiatePaymentException(PaymentInitiationResult result, Throwable ex) {
        this.log.error("payment initiation failed", ex);
        result.setSuccess(false);
        if (result.getPayment() != null) {
            result.getPayment().setStatus(PaymentStatus.ERROR);
        }
        Message errorMessage = MessageHelper.createErrorMessage((String)new ExceptionTranslator().translate(ex), (Object[])new Object[0]);
        result.getMessages().add(errorMessage);
    }

    private void doPaymentFailed(PaymentCheckResult result, Payment clonedPayment) throws Exception {
        this.log.info(String.format("Payment checking - execute paymentFailed [paymentId=%s]", clonedPayment.getPaymentId()));
        this.setPaymentCheckResultStatus(result, false);
        this.paymentFailed(clonedPayment, result.getMessages());
    }

    private void doPaymentSucceeded(PaymentCheckResult result, Payment payment) throws Exception {
        this.log.info(String.format("Payment checking - execute paymentSucceeded [paymentId=%s]", payment.getPaymentId()));
        this.setPaymentCheckResultStatus(result, true);
        EntityContainer<BookingFile> bookingFile = this.resolveEntity(payment);
        LockUtil.lock((EntityReference)bookingFile.toReference(), (long)10L, (TimeUnit)TimeUnit.MINUTES, () -> this.paymentSucceeded(payment, result.getMessages()), () -> {
            throw Xeption.forDeveloper((String)"lock timeout", (Object[])new Object[0]);
        });
    }

    private EntityContainer<BookingFile> resolveEntity(Payment payment) {
        return EntityStorage.get().resolve(payment.getEntity());
    }

    private void checkDisposedState() {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
    }

    private void handleCheckException(Date startDate, PaymentCheckResult result, Exception ex) {
        this.log.error("payment check failed", (Throwable)ex);
        this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)ex));
        result.setSuccess(false);
        result.getMessages().add(MessageHelper.createErrorMessage((String)ex.getMessage(), (Object[])new Object[0]));
        PGInvocationContext.get().addTraceData(startDate, InvocationName.CHECK_PAYMENT.toString(), null, null, (Throwable)ex);
    }

    private List<com.gridnine.xtrip.server.pg.sirena.ws.v2.Payment> getPaymentsInfo(MerchantSettings merchantSettings, String bookingNumber, Date transactionLogDate) throws Exception {
        OrderID orderId = this.handlerFactory.createCheckHandler(merchantSettings).createRequest(bookingNumber);
        try {
            Orderv2 srvOrder = this.serviceRegistry.getAuthenticatedServiceConnection(merchantSettings);
            OrderStatus status = srvOrder.getStatus(orderId);
            PGInvocationContext.get().addTraceData(transactionLogDate, InvocationName.GET_PAYMENT_INFO.toString(), (Object)SirenaPGHelper.toXMLElement(OrderID.class, orderId), (Object)SirenaPGHelper.toXMLElement(OrderStatus.class, status), null);
            return status.getPayments().getPayment();
        }
        catch (Exception e) {
            PGInvocationContext.get().addTraceData(transactionLogDate, InvocationName.GET_PAYMENT_INFO.toString(), (Object)SirenaPGHelper.toXMLElement(OrderID.class, orderId), null, (Throwable)e);
            return null;
        }
    }
}

