/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.sirena.v2;

import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.pg.sirena.SirenaV2PgSettings;
import com.gridnine.xtrip.server.pg.BasePgSettingsProvider;
import java.util.Properties;

public class SirenaV2PgSettingsProvider
extends BasePgSettingsProvider<SirenaV2PgSettings> {
    protected String getPgSettingsUid() {
        return "sirena-v2-pg-configuration";
    }

    protected SirenaV2PgSettings createSettingsFromProperties(Properties properties) throws InstantiationException, IllegalAccessException {
        SirenaV2PgSettings settings = (SirenaV2PgSettings)super.createSettingsFromProperties(properties);
        settings.setTraceEnabled(SirenaV2PgSettingsProvider.isTrue(properties.getProperty("trace.enabled")));
        settings.setQueuePeriod(properties.containsKey("queue.period") ? Integer.valueOf(properties.getProperty("queue.period")) : 0);
        settings.setServiceOrderUrl(properties.getProperty("service.url"));
        ContractType contractType = properties.containsKey("contract.type") ? ContractType.valueOf((String)properties.getProperty("contract.type")) : ContractType.CLIENT;
        settings.setContractType(contractType);
        settings.setShowInIFrame(properties.containsKey("show.in.iframe") ? Boolean.valueOf((String)properties.get("show.in.iframe")) : false);
        return settings;
    }

    protected Class<SirenaV2PgSettings> getSettingsClass() {
        return SirenaV2PgSettings.class;
    }

    protected void setDefaultProperties(SirenaV2PgSettings settings) {
        settings.setName("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u043e\u0433\u043e \u0448\u043b\u044e\u0437\u0430 SirenaV2");
        settings.setType(SystemSettingsType.PG_CONFIGURATION);
        settings.setServiceOrderUrl("https://ws.egopay.ru/order/v2/");
        settings.setServiceStatusUrl("https://tws.egopay.ru/status/v2/");
        settings.setContractType(ContractType.CLIENT);
        settings.setShowInIFrame(false);
        settings.setType(SystemSettingsType.PG_CONFIGURATION);
    }

    protected PgName getPgName() {
        return PgName.SIRENA_V2;
    }

    private static boolean isTrue(String propertyValue) {
        return Boolean.toString(true).equalsIgnoreCase(propertyValue);
    }
}

