/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.sirena.v2.ibus.report;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.pg.sirena.report.Order;
import com.gridnine.xtrip.common.pg.sirena.report.OrderStatus;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jibxws.IBusJibxWsContextKeys;
import com.gridnine.xtrip.server.jibxws.WsResponse;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import com.gridnine.xtrip.server.pg.sirena.ws.status.v2.GetByPaymentPeriodResponse;
import com.gridnine.xtrip.server.pg.sirena.ws.status.v2.Payment;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class GetPaymentsResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        WsResponse wsResponse = (WsResponse)ctx.getMandatoryObject((Enum)IBusJibxWsContextKeys.WS_RESPONSE);
        GetByPaymentPeriodResponse response = (GetByPaymentPeriodResponse)wsResponse.getPayload();
        List<Order> processData = this.processData(response);
        ctx.putObject((Enum)IBusPgConnectorContextKeys.GET_PAYMENTS_REPORT_RESULT, processData);
    }

    public List<Order> processData(GetByPaymentPeriodResponse response) {
        ArrayList<Order> result = new ArrayList<Order>();
        List orderStatuList = response.getRetval().getOrderStatuList();
        if (orderStatuList != null) {
            for (com.gridnine.xtrip.server.pg.sirena.ws.status.v2.OrderStatus order : orderStatuList) {
                Order reportOrder = new Order();
                reportOrder.setOrderNumber(order.getOrder().getNumber());
                reportOrder.setShopId(order.getOrder().getShopId().intValue());
                reportOrder.setStatus(this.toEnum(order.getStatus()));
                result.add(reportOrder);
                List paymentList = order.getPayments().getPaymentList();
                if (paymentList == null) continue;
                for (Payment payment : paymentList) {
                    com.gridnine.xtrip.common.pg.sirena.report.Payment reportPayment = new com.gridnine.xtrip.common.pg.sirena.report.Payment();
                    reportPayment.setAmount(BigDecimal.valueOf(payment.getAmount().getAmount().doubleValue()));
                    reportPayment.setDate(payment.getDate());
                    reportPayment.setId(payment.getId());
                    reportOrder.getPayments().add(reportPayment);
                }
            }
        }
        return result;
    }

    private OrderStatus toEnum(String status) {
        if ("registered".equals(status)) {
            return OrderStatus.REGISTRED;
        }
        if ("in_progress".equals(status)) {
            return OrderStatus.IN_PROGRESS;
        }
        if ("authorized".equals(status)) {
            return OrderStatus.AUTHORIZED;
        }
        if ("failed".equals(status)) {
            return OrderStatus.FAILED;
        }
        if ("acknowledged".equals(status)) {
            return OrderStatus.ACKNOWLEDGED;
        }
        if ("not_acknowledged".equals(status)) {
            return OrderStatus.NOT_ACKNOWLEDGED;
        }
        if ("not_authorized".equals(status)) {
            return OrderStatus.NOT_AUTHORIZED;
        }
        if ("canceled".equals(status)) {
            return OrderStatus.CANCELLED;
        }
        if ("refunded".equals(status)) {
            return OrderStatus.REFUNDED;
        }
        throw Xeption.forDeveloper((String)("unsupported order status " + status), (Object[])new Object[0]);
    }
}

