/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.sprintnet;

import java.util.Properties;

class Configuration {
    private final boolean traceEnabled;
    private final boolean testMode;
    private final Long queuePeriod;
    private final double testAmount;
    private final String login;
    private final String password;
    private final double overpaymentLimit;

    Configuration(Properties data) {
        double overpayment;
        double test;
        this.login = data.getProperty("login");
        this.password = data.getProperty("password");
        this.traceEnabled = Configuration.isTrue(data.getProperty("trace.enabled"));
        this.testMode = Configuration.isTrue(data.getProperty("test.enabled"));
        Long l = this.queuePeriod = data.contains("queue.period") ? Long.valueOf(data.getProperty("queue.period")) : null;
        if (data.getProperty("test.amount") != null) {
            try {
                test = Double.parseDouble(data.getProperty("test.amount"));
            }
            catch (NumberFormatException e) {
                test = 1.0;
            }
        } else {
            test = 1.0;
        }
        this.testAmount = test;
        if (data.getProperty("overpaymentLimit") != null) {
            try {
                overpayment = Double.parseDouble(data.getProperty("overpaymentLimit"));
            }
            catch (NumberFormatException e) {
                overpayment = 10.0;
            }
        } else {
            overpayment = 10.0;
        }
        this.overpaymentLimit = overpayment;
    }

    boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    boolean isValid() {
        return true;
    }

    double getTestAmount() {
        return this.testAmount;
    }

    boolean isTest() {
        return this.testMode;
    }

    Long getQueuePeriod() {
        return this.queuePeriod;
    }

    private static boolean isTrue(String propertyValue) {
        return Boolean.toString(true).equalsIgnoreCase(propertyValue);
    }

    String getLogin() {
        return this.login;
    }

    String getPassword() {
        return this.password;
    }

    double getOverpaymentLimit() {
        return this.overpaymentLimit;
    }
}

