/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.sprintnet;

import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.PGConnectorInfo;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentCheckResult;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.sprintnet.Configuration;

public class SprintNetPGConnector
extends PGConnector {
    private boolean enabled;
    private Configuration configuration;
    private Tracer tracer;

    public PgName getId() {
        return PgName.SPRINTNET;
    }

    protected Tracer getTracer() {
        return this.tracer;
    }

    protected void configure(PGConnectorRegistry registry) {
        super.configure(registry);
        if (!super.isEnabled()) {
            return;
        }
        this.enabled = true;
        this.configuration = new Configuration(this.getConfiguration());
        if (this.configuration.isTraceEnabled()) {
            this.tracer = PGHelper.createTracer((PgName)this.getId());
        }
        this.enabled = this.configuration.isValid();
        if (this.enabled) {
            this.log.debug("configured");
        } else {
            this.log.warn("invalid configuration, SPRINTNET connector disabled");
        }
    }

    protected Long getQueuePeriod() {
        return this.configuration.getQueuePeriod();
    }

    public PGConnectorInfo getConnectorInfo() {
        PGConnectorInfo result = new PGConnectorInfo();
        result.setEnabled(this.isEnabled());
        result.setPg(this.getId());
        result.getSupportedPaymentTypes().add(PaymentType.SPRINTNET);
        return result;
    }

    public void dispose() {
        this.log.debug("disposed");
    }

    public PaymentInitiationResult initiatePayment(PaymentInitiationParameters parameters) {
        throw new UnsupportedOperationException();
    }

    public PaymentCheckResult checkPayment(PaymentCheckParameters parameters) {
        throw new UnsupportedOperationException();
    }
}

