/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.sprintnet;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.WorkflowStatus;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.BaseTransactionDetails;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.model.system.BillingTransactionCategory;
import com.gridnine.xtrip.common.model.system.BillingTransactionIndex;
import com.gridnine.xtrip.common.model.system.BillingTransactionType;
import com.gridnine.xtrip.common.model.system.InvoiceTransactionDetails;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGServlet;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.sprintnet.Configuration;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SprintNetPGServlet
extends PGServlet {
    private static final long serialVersionUID = 5107482932503807081L;
    private static final Logger log = LoggerFactory.getLogger(SprintNetPGServlet.class);
    private static NumberFormat sumF = new DecimalFormat("#0.00");

    private static SimpleDateFormat createDfISO8601() {
        return new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
    }

    protected PgName getId() {
        return PgName.SPRINTNET;
    }

    private boolean authorize(String login, String password) {
        return password != null && login != null && password.equals(this.getConnector().getConfiguration().getProperty("password")) && login.equals(this.getConnector().getConfiguration().getProperty("login"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
        LinkedList pgLog;
        block26: {
            log.debug("service() BEGIN");
            Date startDate = new Date();
            Element response = null;
            HashMap<String, String> request = new HashMap<String, String>();
            LinkedList<Message> messages = new LinkedList<Message>();
            pgLog = new LinkedList();
            try {
                Document doc;
                PGInvocationContext.get().begin(InvocationName.SERVLET_SERVICE.toString());
                req.setCharacterEncoding("UTF-8");
                char[] cbuf = new char[req.getContentLength()];
                req.getReader().read(cbuf);
                String body = new String(cbuf).trim();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_8));
                try {
                    doc = documentBuilderFactory.newDocumentBuilder().parse(inputStream);
                }
                catch (Exception e) {
                    log.error("Could not parse request data", (Throwable)e);
                    response = SprintNetPGServlet.createErrorResponse("10001", e.getMessage());
                    throw new ServletException("Could not parse request data");
                }
                if (doc != null) {
                    NodeList logins = doc.getElementsByTagName("login");
                    if (logins.getLength() != 1) {
                        response = SprintNetPGServlet.createErrorResponse("10001", "Missing/invalid login tag in request data");
                        throw new ServletException("Missing/invalid login tag in request data");
                    }
                    String login = logins.item(0).getTextContent();
                    request.put("login", login);
                    NodeList passwords = doc.getElementsByTagName("password");
                    if (passwords.getLength() != 1) {
                        response = SprintNetPGServlet.createErrorResponse("10001", "Missing/invalid password tag in request data");
                        throw new ServletException("Missing/invalid password tag in request data");
                    }
                    String password = passwords.item(0).getTextContent();
                    request.put("password", password);
                    if (!this.authorize(login, password)) {
                        response = SprintNetPGServlet.createErrorResponse("10002", "Invalid login or password");
                        throw new ServletException("Invalid login or password");
                    }
                    response = SprintNetPGServlet.createSuccessResponse();
                    Node command = passwords.item(0).getNextSibling();
                    if (command == null) {
                        response = SprintNetPGServlet.createErrorResponse("10001", "Missing/invalid command tag in request data");
                        throw new ServletException("Missing/invalid command tag in request data");
                    }
                    request.put("command", command.getNodeName());
                    if ("check".equals(command.getNodeName())) {
                        log.debug("Check command received");
                        NodeList params = command.getFirstChild().getChildNodes();
                        for (int i = 0; i < params.getLength(); ++i) {
                            Node param = params.item(i);
                            if ("account".equals(param.getNodeName()) && param.getChildNodes().getLength() > 0) {
                                request.put("account", param.getTextContent());
                                continue;
                            }
                            request.put(param.getNodeName(), param.getTextContent());
                        }
                        EntityContainer<BookingFile> bfCtr = SprintNetPGServlet.findBookingFile((String)request.get("account"), false);
                        this.check(bfCtr, response, request, messages);
                    } else if ("payments".equals(command.getNodeName())) {
                        log.debug("Payments command received");
                        NodeList payments = command.getChildNodes();
                        for (int i = 0; i < payments.getLength(); ++i) {
                            Node payment = payments.item(i);
                            if (!"payment".equals(payment.getNodeName())) continue;
                            NodeList params = payment.getChildNodes();
                            HashMap<String, String> paymentRequest = new HashMap<String, String>();
                            for (int j = 0; j < params.getLength(); ++j) {
                                Node param = params.item(j);
                                paymentRequest.put(param.getNodeName(), param.getTextContent());
                            }
                            EntityContainer<BookingFile> bfCtr = SprintNetPGServlet.findBookingFile((String)paymentRequest.get("account"), false);
                            this.payment(bfCtr, response, paymentRequest, messages);
                            PGInvocationContext.get().addTraceData(startDate, "payment", paymentRequest, (Object)response, null);
                        }
                    } else if ("status".equals(command.getNodeName())) {
                        log.debug("Status command received");
                        NodeList payments = command.getChildNodes();
                        for (int i = 0; i < payments.getLength(); ++i) {
                            Node payment = payments.item(i);
                            if (!"payment".equals(payment.getNodeName())) continue;
                            NodeList params = payment.getChildNodes();
                            HashMap<String, String> statusRequest = new HashMap<String, String>();
                            for (int j = 0; j < params.getLength(); ++j) {
                                Node param = params.item(j);
                                statusRequest.put(param.getNodeName(), param.getTextContent());
                            }
                            if (statusRequest.get("id") == null) {
                                response = SprintNetPGServlet.createErrorResponse("10001", "Invalid status request");
                                throw new ServletException("Invalid status request");
                            }
                            this.status((String)statusRequest.get("id"), response, statusRequest, messages);
                            PGInvocationContext.get().addTraceData(startDate, "status", statusRequest, (Object)response, null);
                        }
                    } else {
                        response = SprintNetPGServlet.createErrorResponse("10001", "Unknown command tag in request data");
                        throw new ServletException("Unknown command tag in request data");
                    }
                }
                PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), request, (Object)response, null);
                if (response == null) break block26;
            }
            catch (Throwable t) {
                block27: {
                    try {
                        log.error("service failed", t);
                        if (response == null) {
                            response = SprintNetPGServlet.createErrorResponse(t);
                        }
                        PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), request, (Object)response, t);
                        if (response == null) break block27;
                    }
                    catch (Throwable throwable) {
                        if (response != null) {
                            this.sendResponse(res, response);
                        }
                        PGInvocationContext.get().end(this.getConnector(), pgLog);
                        LogicalStorage.reset();
                        throw throwable;
                    }
                    this.sendResponse(res, response);
                }
                PGInvocationContext.get().end(this.getConnector(), pgLog);
                LogicalStorage.reset();
            }
            this.sendResponse(res, response);
        }
        PGInvocationContext.get().end(this.getConnector(), pgLog);
        LogicalStorage.reset();
        log.debug("service() END");
    }

    private Element status(String id, Element elm, Map<String, String> request, List<Message> messages) throws Exception {
        BillingTransactionIndex tri = this.getTransaction(id);
        return SprintNetPGServlet.addStatusResult(elm, id, tri != null ? "0" : "-1", tri != null ? "\u0417\u0430\u044f\u0432\u043a\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u0430" : "\u041f\u043b\u0430\u0442\u0435\u0436 \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(HttpServletResponse res, Element response) throws IOException {
        try {
            res.getOutputStream().write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes());
            XUtil.newTransformer().transform(new DOMSource(response), new StreamResult((OutputStream)res.getOutputStream()));
            res.getOutputStream().flush();
        }
        catch (Exception ex) {
            log.error("error while sending response", (Throwable)ex);
        }
        finally {
            res.getOutputStream().close();
        }
    }

    private static Element createErrorResponse(Throwable t) {
        return SprintNetPGServlet.createErrorResponse("20001", t.getMessage());
    }

    private static Element createErrorResponse(String code, String text) {
        Element elm = SprintNetPGServlet.createResponse();
        XHelper.writeString((Element)elm, (String)"error", (String)code);
        return elm;
    }

    private static Element addCheckResult(Element elm, String id, String code, String omsg, String imsg, BigDecimal sum, Date dateTime) {
        Document doc = elm.getOwnerDocument();
        Element result = doc.createElement("result");
        XHelper.writeString((Element)result, (String)"id", (String)id);
        XHelper.writeString((Element)result, (String)"code", (String)code);
        XHelper.writeString((Element)result, (String)"omsg", (String)omsg);
        XHelper.writeString((Element)result, (String)"imsg", (String)imsg);
        XHelper.writeBigDecimal((Element)result, (String)"sum", (BigDecimal)sum);
        XHelper.writeString((Element)result, (String)"datetime", (String)SprintNetPGServlet.createDfISO8601().format(dateTime));
        elm.appendChild(result);
        return elm;
    }

    private static Element addPaymentResult(Element elm, String id, String code, String omsg, Date dateTime) {
        Document doc = elm.getOwnerDocument();
        Element result = doc.createElement("result");
        XHelper.writeString((Element)result, (String)"id", (String)id);
        XHelper.writeString((Element)result, (String)"code", (String)code);
        XHelper.writeString((Element)result, (String)"omsg", (String)omsg);
        XHelper.writeString((Element)result, (String)"datetime", (String)SprintNetPGServlet.createDfISO8601().format(dateTime));
        elm.appendChild(result);
        return elm;
    }

    private static Element addStatusResult(Element elm, String id, String code, String omsg, Date dateTime) {
        Document doc = elm.getOwnerDocument();
        Element result = doc.createElement("result");
        XHelper.writeString((Element)result, (String)"id", (String)id);
        XHelper.writeString((Element)result, (String)"code", (String)code);
        XHelper.writeString((Element)result, (String)"omsg", (String)omsg);
        XHelper.writeString((Element)result, (String)"datetime", (String)SprintNetPGServlet.createDfISO8601().format(dateTime));
        elm.appendChild(result);
        return elm;
    }

    private static Element createSuccessResponse() {
        return SprintNetPGServlet.createErrorResponse("0", "ok");
    }

    private static Element createResponse() {
        Document doc = DocumentBuilderHelper.newDocument();
        Element elm = doc.createElement("package");
        elm.setAttribute("version", "4.0");
        doc.appendChild(elm);
        return elm;
    }

    private static EntityContainer<BookingFile> findBookingFile(String bookingNumber, boolean toBePayed) throws Exception {
        List result = PaymentHelper.searchBookingFile((String)bookingNumber, (boolean)toBePayed);
        if (result.size() != 1) {
            return null;
        }
        return EntityStorage.get().resolve(((BookingFileIndex)result.get(0)).getSource());
    }

    private List<BillingTransactionIndex> getTransactions(EntityContainer<BookingFile> bfCtr) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.referencedEntity.name(), (Object)bfCtr.toReference()));
        SearchResult searchResult = LogicalStorage.get().getEntityStorage().search(BillingTransactionIndex.class, query);
        return searchResult.getData();
    }

    private BillingTransactionIndex getTransaction(String code) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.transactionCode.name(), (Object)code));
        SearchResult searchResult = LogicalStorage.get().getEntityStorage().search(BillingTransactionIndex.class, query);
        if (searchResult.getTotalCount() == 0) {
            return null;
        }
        return (BillingTransactionIndex)searchResult.getData().get(0);
    }

    private Element check(EntityContainer<BookingFile> bfCtr, Element elm, Map<String, String> request, List<Message> messages) throws Exception {
        if (bfCtr == null) {
            return SprintNetPGServlet.addCheckResult(elm, request.get("id"), "1001", "", "", BigDecimal.ZERO, new Date());
        }
        Configuration config = new Configuration(this.getConnector().getConfiguration());
        BigDecimal actualPrice = config.isTest() ? BigDecimal.valueOf(config.getTestAmount()) : (BigDecimal)PaymentHelper.getTotalPrices((EntityReference)bfCtr.toReference(), (ContractType)ContractType.CLIENT).get(PaymentType.SPRINTNET);
        List<BillingTransactionIndex> transactions = this.getTransactions(bfCtr);
        if (transactions.size() == 0) {
            return SprintNetPGServlet.addCheckResult(elm, request.get("id"), "0", "\u0417\u0430\u044f\u0432\u043a\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u0430", "\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e\u0442 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430", actualPrice, new Date());
        }
        BigDecimal sum = BigDecimal.ZERO;
        for (BillingTransactionIndex tr : transactions) {
            sum = sum.add(tr.getTransactionSum());
        }
        return SprintNetPGServlet.addCheckResult(elm, request.get("id"), "0", "\u0417\u0430\u044f\u0432\u043a\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u0430", "\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e\u0442 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430", actualPrice.subtract(sum), new Date());
    }

    private Element payment(EntityContainer<BookingFile> bfCtr, Element elm, Map<String, String> request, List<Message> messages) throws Exception {
        try {
            BillingTransactionIndex existingTransaction = this.getTransaction(request.get("id"));
            if (existingTransaction != null) {
                return SprintNetPGServlet.addPaymentResult(elm, request.get("id"), "0", "Payment success", existingTransaction.getTransactionDate());
            }
            if (bfCtr == null) {
                return SprintNetPGServlet.addPaymentResult(elm, request.get("id"), "1001", "Booking not found", new Date());
            }
            if (((BookingFile)bfCtr.getEntity()).getWorkflowStatus() == WorkflowStatus.CANCELED) {
                return SprintNetPGServlet.addPaymentResult(elm, request.get("id"), "1006", "Booking is cancelled", new Date());
            }
            if (((BookingFile)bfCtr.getEntity()).getWorkflowStatus() == WorkflowStatus.ISSUED) {
                return SprintNetPGServlet.addPaymentResult(elm, request.get("id"), "1006", "Booking is already issued", new Date());
            }
            if (((BookingFile)bfCtr.getEntity()).getWorkflowStatus() != WorkflowStatus.BOOKING && ((BookingFile)bfCtr.getEntity()).getWorkflowStatus() != WorkflowStatus.TO_BE_PAYED) {
                return SprintNetPGServlet.addPaymentResult(elm, request.get("id"), "1006", "Booking is invalid", new Date());
            }
            Configuration config = new Configuration(this.getConnector().getConfiguration());
            BigDecimal actualPrice = config.isTest() ? BigDecimal.valueOf(config.getTestAmount()) : (BigDecimal)PaymentHelper.getTotalPrices((EntityReference)bfCtr.toReference(), (ContractType)ContractType.CLIENT).get(PaymentType.SPRINTNET);
            BigDecimal authSum = new BigDecimal(request.get("toamount"));
            List<BillingTransactionIndex> transactions = this.getTransactions(bfCtr);
            BigDecimal alreadyPaid = BigDecimal.ZERO;
            for (BillingTransactionIndex tr : transactions) {
                alreadyPaid = alreadyPaid.add(tr.getTransactionSum());
            }
            BigDecimal totalPaid = authSum.add(alreadyPaid);
            BigDecimal diff = actualPrice.subtract(totalPaid);
            if ((double)diff.floatValue() < -config.getOverpaymentLimit()) {
                return SprintNetPGServlet.addPaymentResult(elm, request.get("id"), "1016", "Paid more than needed, actual price is: " + sumF.format(actualPrice) + ", total paid: " + sumF.format(totalPaid), new Date());
            }
            EntityContainer btCtr = new EntityContainer(BillingTransaction.class);
            ((BillingTransaction)btCtr.getEntity()).setAgency(((BookingFile)bfCtr.getEntity()).getAgency());
            ((BillingTransaction)btCtr.getEntity()).setCategory(BillingTransactionCategory.DEBIT);
            ((BillingTransaction)btCtr.getEntity()).setEntity(bfCtr.toReference());
            ((BillingTransaction)btCtr.getEntity()).setDate(new Date());
            ((BillingTransaction)btCtr.getEntity()).setDescription("");
            InvoiceTransactionDetails details = new InvoiceTransactionDetails();
            details.setTransactionCode(request.get("id"));
            ((BillingTransaction)btCtr.getEntity()).setDetails((BaseTransactionDetails)details);
            ((BillingTransaction)btCtr.getEntity()).setPaymentType(PaymentType.SPRINTNET);
            Money money = new Money();
            money.setCurrency(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
            money.setValue(authSum);
            ((BillingTransaction)btCtr.getEntity()).setSum(money);
            ((BillingTransaction)btCtr.getEntity()).setType(BillingTransactionType.BILLING);
            EntityStorage.get().save(btCtr, true);
            Message info = MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0421\u043e\u0437\u0434\u0430\u043d\u0430 \u0431\u0438\u043b\u043b\u0438\u043d\u0433-\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 {0} {1}", (Object[])new Object[]{((BillingTransaction)btCtr.getEntity()).getSum().getValue(), ((BillingTransaction)btCtr.getEntity()).getSum().getCurrency()});
            messages.add(info);
            log.info(info.toString());
            if (diff.floatValue() <= 0.0f) {
                Payment payment = PaymentHelper.createPayment(bfCtr, (PaymentType)PaymentType.SPRINTNET, (ContractType)ContractType.CLIENT);
                payment.setBillingTransaction(btCtr.toReference());
                this.paymentSucceeded(payment, messages);
            }
            return SprintNetPGServlet.addPaymentResult(elm, request.get("id"), "0", "Payment success", ((BillingTransaction)btCtr.getEntity()).getDate());
        }
        catch (Exception e) {
            log.error("Payment failure for " + request.get("account"), (Throwable)e);
            return SprintNetPGServlet.addPaymentResult(elm, request.get("id"), "1006", "Payment failure", new Date());
        }
    }
}

