/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.uniteller;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.uniteller.UnitellerSettings;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.split.SplitPaymentHelper;
import com.gridnine.xtrip.server.pg.uniteller.MerchantSettings;
import com.gridnine.xtrip.server.pg.uniteller.OrderTransactions;
import com.gridnine.xtrip.server.pg.uniteller.SFieldsList;
import com.gridnine.xtrip.server.pg.uniteller.UnitellerHelper;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckOrder {
    private static final Logger log = LoggerFactory.getLogger(CheckOrder.class);
    private final String orderId;
    private final MerchantSettings settings;
    private final BigDecimal mustBePayed;
    private final UnitellerSettings unitellerSettings;
    private OrderTransactions transactions;
    private boolean fullyPayed = false;
    private boolean initialized;

    public CheckOrder(String orderId, MerchantSettings settings, UnitellerSettings unitellerSettings, BigDecimal toPay) {
        this.orderId = orderId;
        this.settings = settings;
        this.unitellerSettings = unitellerSettings;
        this.mustBePayed = toPay;
    }

    public OrderTransactions getTransactions() {
        this.checkInitialization();
        return this.transactions;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void check() {
        this.retrievePaymentDetails(() -> this.buildParams(), this::processServerResponse);
        this.setFullyPayed();
        this.initialized = true;
    }

    private void checkInitialization() {
        if (!this.isInitialized()) {
            throw Xeption.forDeveloper((String)"not initialized", (Object[])new Object[0]);
        }
    }

    private void processServerResponse(String response) {
        this.transactions = new OrderTransactions(new SFieldsList().parsePaymentInformation(response.toString()));
    }

    private void setFullyPayed() {
        BigDecimal payedTotal = this.transactions.getPayedTotal();
        this.fullyPayed = this.mustBePayed.compareTo(payedTotal) == 0;
        log.trace(String.format("Payed price=%.2f, orderPrice=%.2f", payedTotal, this.mustBePayed));
    }

    public boolean isFullyPayed() {
        this.checkInitialization();
        return this.fullyPayed;
    }

    public boolean updateModels(Payment payment, EntityContainer<BookingFile> bookingFile) {
        this.checkInitialization();
        try {
            this.saveApprovalCodeInRemarks(bookingFile);
            payment.setDetails(this.transactions.createCardDetails());
            return true;
        }
        catch (Exception e) {
            log.error("updateModels exception", (Throwable)e);
            return false;
        }
    }

    private void saveApprovalCodeInRemarks(EntityContainer<BookingFile> bookingFile) {
        Optional<String> approvalCode = this.transactions.getGdsApprovalCode();
        approvalCode.ifPresent(code -> SplitPaymentHelper.saveApprovalCodeRemark((EntityContainer)bookingFile, (String)code));
    }

    private void retrievePaymentDetails(Supplier<Map<String, String>> paramsSupplier, Consumer<String> consumeResponse) {
        HashMap<String, String> params = new HashMap<String, String>();
        Date startDate = new Date();
        StringBuilder serverResponse = new StringBuilder();
        try {
            HttpsURLConnection connection = this.buildHttpConnection();
            params.putAll(paramsSupplier.get());
            serverResponse.append(this.executeHttpConnection(params, connection));
            consumeResponse.accept(serverResponse.toString());
            PGInvocationContext.get().addTraceData(startDate, InvocationName.GET_PAYMENT_INFO.toString(), params, (Object)serverResponse.toString(), null);
        }
        catch (Exception e) {
            PGInvocationContext.get().addTraceData(startDate, InvocationName.GET_PAYMENT_INFO.toString(), params, (Object)serverResponse.toString(), (Throwable)e);
            log.error("retrievePaymentDetails", (Throwable)e);
        }
    }

    public String executeHttpConnection(Map<String, String> params, HttpsURLConnection connection) throws Exception {
        return UnitellerHelper.executeHttpConnection(connection, params);
    }

    private HttpsURLConnection buildHttpConnection() throws IOException {
        URL url = new URL(this.unitellerSettings.getCheckUrl());
        if (this.unitellerSettings.isTestMode()) {
            this.disableHostVerification();
        }
        return (HttpsURLConnection)url.openConnection();
    }

    private void disableHostVerification() {
        HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
    }

    private Map<String, String> buildParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Shop_ID", this.settings.getShopIdpPrimary());
        params.put("Login", this.settings.getLogin());
        params.put("Password", this.settings.getPassword());
        params.put("ShopOrderNumber", this.orderId);
        params.put("S_FIELDS", new SFieldsList().getRequestSFieldsValue());
        params.put("Format", "1");
        return params;
    }

    public boolean isNeedToConfirm() {
        return !this.transactions.getBillingNumbersToConfirm().isEmpty();
    }
}

