/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.uniteller;

import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.uniteller.UnitellerSettings;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.uniteller.MerchantSettings;
import com.gridnine.xtrip.server.pg.uniteller.UnitellerHelper;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfirmPayment {
    private static final int SEND_CONFIRMATION_RETRY_COUNT = 5;
    private static final Logger log = LoggerFactory.getLogger(ConfirmPayment.class);
    private final String billNumber;
    private final String iData;
    private final UnitellerSettings config;
    private final MerchantSettings merchantSettings;
    private final PGConnector connector;
    private AtomicInteger retries = new AtomicInteger(5);
    private boolean successfulResult;

    public void setSuccessfulResult(boolean successfulResult) {
        this.successfulResult = successfulResult;
    }

    public boolean isSuccessfulResult() {
        return this.successfulResult;
    }

    public ConfirmPayment(String billNumber, String iData, UnitellerSettings config, MerchantSettings settings, PGConnector connector) {
        this.billNumber = billNumber;
        this.iData = iData;
        this.config = config;
        this.merchantSettings = settings;
        this.connector = connector;
        log.trace(String.format("schedulePaymentConfirmation [billNumber=%s]", billNumber));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeOneCall() {
        int retry = this.retries.decrementAndGet();
        log.debug(String.format("retry=%d, Send preAuthorizationConfirm, billNumber=%s, iData=%s", retry, this.billNumber, this.iData));
        PGInvocationContext.get().begin(InvocationName.PAYMENT_CONFIRM.toString());
        Date startDate = new Date();
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        String serverResponse = "";
        try {
            this.setRequestParams(requestParameters);
            serverResponse = this.invokeHttp(requestParameters);
            log.debug("PreauthConfirmResponse: " + serverResponse);
            this.setSuccessfulResult(this.isSuccessfulResponse(serverResponse));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.PAYMENT_CONFIRM.toString(), requestParameters, (Object)serverResponse, null);
        }
        catch (Exception e) {
            PGInvocationContext.get().addTraceData(startDate, InvocationName.PAYMENT_CONFIRM.toString(), requestParameters, (Object)serverResponse, (Throwable)e);
            log.error("", (Throwable)e);
        }
        finally {
            PGInvocationContext.get().end(this.connector, null);
        }
        if (!this.isSuccessfulResult()) {
            log.error(String.format("Preauth confirm error, billNumber [%s]. Re-Scheduling confirmation.", this.billNumber));
            this.scheduleOneCall(this.createInterval(30));
        } else {
            log.trace(String.format("Uniteller's transaction is confirmed [billNumber = %s]", this.billNumber));
        }
    }

    boolean AreAttemptsExasted() {
        return this.retries.get() == 0;
    }

    void setRequestParams(Map<String, String> requestParameters) {
        requestParameters.put("Shop_ID", this.merchantSettings.getShopIdpPrimary());
        requestParameters.put("Login", this.merchantSettings.getLogin());
        requestParameters.put("Password", this.merchantSettings.getPassword());
        requestParameters.put("Billnumber", this.billNumber);
        requestParameters.put("URL", this.config.getConfirmUrl());
        if (!TextUtil.isBlank((String)this.iData)) {
            requestParameters.put("IData", this.iData);
        }
    }

    public String invokeHttp(Map<String, String> requestParameters) throws Exception {
        URL url = new URL(this.config.getConfirmUrl());
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        return UnitellerHelper.executeHttpConnection(connection, requestParameters);
    }

    private boolean isSuccessfulResponse(String response) {
        return response != null && response.indexOf("ErrorCode;ErrorMessage") == -1;
    }

    public void execute() {
        this.scheduleOneCall(this.createInterval(0));
    }

    private void scheduleOneCall(Date time) {
        if (this.AreAttemptsExasted()) {
            return;
        }
        new Timer("uniteller-confirmation", true).schedule(new TimerTask(){

            @Override
            public void run() {
                ConfirmPayment.this.makeOneCall();
            }
        }, time);
    }

    public Date createInterval(int addSeconds) {
        Calendar cal = Calendar.getInstance();
        cal.add(13, addSeconds);
        return cal.getTime();
    }
}

