/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.uniteller;

import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.pg.uniteller.UnitellerSettings;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.uniteller.UnitellerConfiguration;
import com.gridnine.xtrip.server.pg.uniteller.UnitellerHelper;
import com.gridnine.xtrip.server.pg.uniteller.UnitellerSettingsProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DBUnitellerSettingsProvider
implements UnitellerSettingsProvider {
    private static final Logger log = Logger.getLogger(UnitellerHelper.class);
    private final String UNITELLER_CONFIGURATION_UID = "uniteller-pg-configuration";

    @Override
    public UnitellerSettings get() {
        EntityContainer<UnitellerSettings> result = this.loadSettingFromDb();
        if (result != null) {
            return (UnitellerSettings)result.getEntity();
        }
        return this.createSettings();
    }

    private UnitellerSettings createSettings() {
        try {
            return (UnitellerSettings)LockUtil.lock((String)"uniteller-pg-configuration", () -> {
                EntityContainer<UnitellerSettings> result = this.loadSettingFromDb();
                if (result != null) {
                    return (UnitellerSettings)result.getEntity();
                }
                UnitellerSettings newConfig = this.loadFromFileOrCreate();
                newConfig.setName("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u043e\u0433\u043e \u0448\u043b\u044e\u0437\u0430 Uniteller");
                newConfig.setType(SystemSettingsType.PG_CONFIGURATION);
                this.saveSettings(newConfig);
                return newConfig;
            });
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            throw new PGException("Couldn't get pg settings");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnitellerSettings loadFromFileOrCreate() {
        File file = PGHelper.getConfigurationFile((PgName)PgName.UNITELLER, (boolean)false);
        if (file.exists()) {
            UnitellerSettings unitellerSettings;
            Properties config = new Properties();
            FileInputStream strm = new FileInputStream(file);
            try {
                config.load(strm);
                unitellerSettings = this.createSettingsFromProperties(config);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)strm).close();
                    throw throwable;
                }
                catch (Exception e) {
                    log.error((Object)("failed loading configuration from file " + file), (Throwable)e);
                }
            }
            ((InputStream)strm).close();
            return unitellerSettings;
        }
        return this.createDefaultSettings();
    }

    private UnitellerSettings createDefaultSettings() {
        UnitellerSettings settings = new UnitellerSettings();
        settings.setContractType(ContractType.CLIENT);
        settings.setTestMode(false);
        settings.setCheckAllIssued(false);
        settings.setUseServletServiceDelay(false);
        return settings;
    }

    private UnitellerSettings createSettingsFromProperties(Properties configProperties) {
        UnitellerSettings settings = new UnitellerSettings();
        UnitellerConfiguration config = new UnitellerConfiguration(configProperties);
        settings.setCheckAllIssued(config.isCheckAllIssued());
        settings.setCheckUrl(config.getCheckUrl());
        settings.setRedirectUrl(config.getRedirectUrl());
        settings.setRefundUrl(config.getRefundUrl());
        settings.setTestMode(config.isTestMode());
        settings.setConfirmUrl(config.getConfirmUrl());
        settings.setTestPrice(config.getTestAmount());
        settings.setContractType(config.getContractType());
        settings.setUseServletServiceDelay(config.isUseServletServiceDelay());
        return settings;
    }

    private void saveSettings(UnitellerSettings newConfig) {
        EntityContainer container = EntityContainer.create((BaseEntity)newConfig);
        container.setUid("uniteller-pg-configuration");
        container.setCreatedBy("system");
        container.getVersionInfo().setCreatedBy("system");
        EntityStorage.get().save(container, true);
    }

    private EntityContainer<UnitellerSettings> loadSettingFromDb() {
        EntityReference<UnitellerSettings> settingsRef = this.createSettingsReference();
        return EntityStorage.get().resolve(settingsRef);
    }

    private EntityReference<UnitellerSettings> createSettingsReference() {
        return new EntityReference("uniteller-pg-configuration", UnitellerSettings.class, null);
    }
}

