/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.uniteller;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.uniteller.UnitellerSettings;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.uniteller.OrderTotalPriceProvider;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOrderTotalPriceProvider
implements OrderTotalPriceProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultOrderTotalPriceProvider.class);

    @Override
    public BigDecimal get(EntityReference<BookingFile> bookingFileRef, PaymentType paymentType, UnitellerSettings config) {
        try {
            return config.isTestMode() ? config.getTestPrice() : (BigDecimal)PaymentHelper.getTotalPrices(bookingFileRef, (ContractType)config.getContractType()).get(paymentType);
        }
        catch (Exception e) {
            log.error("OrderTotalPriceProvider error", (Throwable)e);
            throw new PGException("Cannot get order price");
        }
    }
}

