/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.uniteller;

import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.uniteller.MerchantSettings;
import com.gridnine.xtrip.server.pg.uniteller.TransactionRecord;
import com.gridnine.xtrip.server.pg.uniteller.UnitellerConfiguration;
import com.gridnine.xtrip.server.pg.uniteller.UnitellerHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class GetTransactions {
    static final int MAX_PERIOD_LENGTH_IN_DAYS = 6;
    protected static final Logger log = LoggerFactory.getLogger(GetTransactions.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<TransactionRecord> getTransactions(PGParameters pgParameters, UnitellerConfiguration configuration, PGConnector connector, LocalDate startPeriod, LocalDate endPeriod) throws Exception {
        int daysBetween = Days.daysBetween((ReadablePartial)new LocalDate((Object)startPeriod), (ReadablePartial)new LocalDate((Object)endPeriod)).getDays();
        if (daysBetween > 6) {
            throw new Exception(String.format("Dates period [%d] exceedes max period length [%d]", daysBetween, 6));
        }
        PGInvocationContext.get().begin(InvocationName.GET_PAYMENT_INFO.toString());
        Date currentDate = new Date();
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        StringBuilder serverResponse = new StringBuilder();
        try {
            URL url = new URL(configuration.getCheckUrl());
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            MerchantSettings merchantSettings = new MerchantSettings(pgParameters);
            requestParameters.put("Shop_ID", merchantSettings.getShopIdpPrimary());
            requestParameters.put("Login", merchantSettings.getLogin());
            requestParameters.put("Password", merchantSettings.getPassword());
            requestParameters.put("StartDay", String.valueOf(startPeriod.getDayOfMonth()));
            requestParameters.put("StartMonth", String.valueOf(startPeriod.getMonthOfYear()));
            requestParameters.put("StartYear", String.valueOf(startPeriod.getYear()));
            requestParameters.put("EndDay", String.valueOf(endPeriod.getDayOfMonth()));
            requestParameters.put("EndMonth", String.valueOf(endPeriod.getMonthOfYear()));
            requestParameters.put("EndYear", String.valueOf(endPeriod.getYear()));
            requestParameters.put("Format", "4");
            serverResponse.append(UnitellerHelper.executeHttpConnection(connection, requestParameters));
            ByteArrayInputStream is = new ByteArrayInputStream(serverResponse.toString().getBytes("UTF-8"));
            Element result = DocumentBuilderHelper.parse((InputStream)is).getDocumentElement();
            for (Element order : XmlUtil.getElements((Element)result, (String)"orders/order")) {
                String ordernumber = XHelper.readString((Element)order, (String)"ordernumber");
                System.out.println(ordernumber);
            }
            PGInvocationContext.get().addTraceData(currentDate, InvocationName.GET_PAYMENT_INFO.toString(), requestParameters, (Object)result, null);
            LinkedList<TransactionRecord> linkedList = new LinkedList<TransactionRecord>();
            return linkedList;
        }
        catch (Exception e) {
            PGInvocationContext.get().addTraceData(currentDate, InvocationName.GET_PAYMENT_INFO.toString(), requestParameters, (Object)serverResponse, (Throwable)e);
            log.error("getTransactions", (Throwable)e);
            List<TransactionRecord> list = null;
            return list;
        }
        finally {
            PGInvocationContext.get().end(connector, null);
        }
    }
}

