/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.uniteller;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.uniteller.UnitellerSettings;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.split.SplitPaymentHelper;
import com.gridnine.xtrip.server.pg.uniteller.MerchantSettings;
import com.gridnine.xtrip.server.pg.uniteller.UnitellerHelper;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitiatePayment {
    static final String SPLIT_PAYMENT_QUEUE_POSTFIX = "/split";
    static final Map<CardVendor, String> defaultCardCodes = new HashMap<CardVendor, String>();
    static final Map<CardVendor, String> unitellerCardVendors = new HashMap<CardVendor, String>();
    private static final Logger log = LoggerFactory.getLogger(InitiatePayment.class);
    private final DecimalFormat priceFormat;
    private final PaymentInitiationResult initiateResult;
    private final PaymentInitiationParameters initiateParams;
    private final UnitellerSettings unitellerSettings;
    private final BigDecimal totalPrice;
    private final EntityContainer<BookingFile> bookingFile;
    private final MerchantSettings settings;

    public InitiatePayment(PaymentInitiationResult result, PaymentInitiationParameters parameters, MerchantSettings settings, UnitellerSettings unitellerSettings, BigDecimal totalPrice) {
        this.initiateResult = result;
        this.initiateParams = parameters;
        this.settings = settings;
        this.unitellerSettings = unitellerSettings;
        this.totalPrice = totalPrice;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        this.priceFormat = new DecimalFormat("0.00", dfs);
        this.bookingFile = EntityStorage.get().resolve(this.initiateParams.getPayment().getEntity());
    }

    public BigDecimal getCommisionPrice(BigDecimal totalPrice) {
        BigDecimal commisionPart = this.unitellerSettings.isTestMode() ? BigDecimal.ONE : SplitPaymentHelper.getSplitPaymentCommisionPartAmount((BookingFile)((BookingFile)this.bookingFile.getEntity()), (BigDecimal)totalPrice);
        return commisionPart;
    }

    public void process() {
        if (this.isUseSplitScheme()) {
            this.processSplitScheme();
        } else {
            this.processCommonScheme();
        }
    }

    public boolean isUseSplitScheme() {
        return UnitellerHelper.canUseSplitScheme(this.initiateParams.getPayment(), this.bookingFile);
    }

    private void processCommonScheme() {
        String orderNumber = TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)this.bookingFile.getEntity()));
        this.initiateParams.getPayment().setPaymentId(orderNumber);
        String pnr = this.getPnr();
        this.setBasicRedirectFormProps();
        this.addFormParam(this.namedValue("Subtotal_P", this.priceFormat.format(this.totalPrice)));
        this.addFormParam(this.namedValue("Order_IDP", orderNumber.toString()));
        if (pnr != null && !"".equalsIgnoreCase(pnr)) {
            this.addFormParam(this.namedValue("Comment", orderNumber.toString()));
        }
        String shopId = this.settings.getShopIdpPrimary();
        this.addFormParam(this.namedValue("Shop_IDP", shopId));
        this.addURLParams();
        String paymentType = this.getPaymentType();
        this.addEMoneyParam(paymentType);
        this.addPreAuthParam();
        String meanType = this.getMeanType();
        this.addMeanTypeParam(meanType);
        this.addSecuritySignature(orderNumber, this.priceFormat.format(this.totalPrice), shopId, meanType, paymentType);
        this.addFormParam(this.namedValue("Language", this.getUserLocale()));
    }

    private String getPnr() {
        String pnr = "";
        try {
            pnr = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)BookingHelper.getBaseProductReservation((BookingFile)((BookingFile)this.bookingFile.getEntity())));
        }
        catch (Throwable t) {
            log.warn("failed to substitute payment id with pnr", t);
        }
        return pnr;
    }

    private void addPreAuthParam() {
        if (this.initiateParams.getPayment().getPaymentType() == PaymentType.CREDIT_CARD_UNITELLER) {
            this.addFormParam(this.namedValue("Preauth", "1"));
            return;
        }
        if (this.isUseSplitAuth()) {
            this.addFormParam(this.namedValue("Preauth", "1"));
            return;
        }
    }

    private boolean isUseSplitAuth() {
        return this.initiateParams.getPayment().getPaymentType() == PaymentType.CREDIT_CARD_SPLIT_UNITELLER && this.settings.isUseSplitAuth();
    }

    private void addURLParams() {
        this.addFormParam(this.namedValue("URL_RETURN_OK", this.initiateParams.getReturnUrl() + "&status=1"));
        this.addFormParam(this.namedValue("URL_RETURN_NO", this.initiateParams.getReturnUrl() + "&status=0"));
    }

    private void addEMoneyParam(String paymentType) {
        if (!paymentType.equalsIgnoreCase("")) {
            this.addFormParam(this.namedValue("EMoneyType", paymentType));
        }
    }

    private String getUserLocale() {
        return this.initiateParams.getPayment().getCustomerInfo().getPreferredLocale() != null && "en".equalsIgnoreCase(this.initiateParams.getPayment().getCustomerInfo().getPreferredLocale().getLanguage()) ? "en" : "ru";
    }

    protected void addFormParam(NamedValue value) {
        this.initiateResult.getRedirectForm().getParameters().add(value);
    }

    private void processSplitScheme() {
        String fullOrderNumber = TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)this.bookingFile.getEntity()));
        this.initiateParams.getPayment().setPaymentId(fullOrderNumber + SPLIT_PAYMENT_QUEUE_POSTFIX);
        BigDecimal commisionPart = this.getCommisionPrice(this.totalPrice);
        Reservation reservation = BookingHelper.getBaseProductReservation((BookingFile)((BookingFile)this.bookingFile.getEntity()));
        String pnr = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation);
        this.setBasicRedirectFormProps();
        String gdsId = this.getUnitellerGdsId((BookingFile)this.bookingFile.getEntity());
        this.addFormParam(this.namedValue("IDataGDS[GDS_ID]", gdsId));
        this.addFormParam(this.namedValue("Subtotal_P", this.priceFormat.format(this.totalPrice)));
        this.addFormParam(this.namedValue("IDataGDS[Commission]", this.priceFormat.format(commisionPart)));
        this.addFormParam(this.namedValue("Order_IDP", fullOrderNumber.toString()));
        this.addFormParam(this.namedValue("Shop_IDP", this.settings.getShopIdpPrimary()));
        if (!TextUtil.isBlank((String)this.settings.getShopIdpSecondary())) {
            this.addFormParam(this.namedValue("IDataGDS[Shop_IDP_toBank]", this.settings.getShopIdpSecondary()));
        } else {
            this.addFormParam(this.namedValue("IDataGDS[Shop_IDP_toBank]", this.settings.getShopIdpPrimary()));
        }
        this.addFormParam(this.namedValue("IDataGDS[PNR]", pnr));
        this.addURLParams();
        String paymentType = this.getPaymentType();
        this.addEMoneyParam(paymentType);
        String meanType = "";
        this.addMeanTypeParam("");
        this.addPreAuthParam();
        if (CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)reservation) == GdsName.SABRE) {
            this.addSabreCardMatchingValues();
        }
        this.addSplitSecuritySignature(this.priceFormat.format(this.totalPrice), gdsId, this.priceFormat.format(commisionPart), this.settings.getShopIdpSecondary(), "", paymentType, fullOrderNumber);
        this.addFormParam(this.namedValue("Language", this.getUserLocale()));
    }

    private String getUnitellerGdsId(BookingFile bookingFile) {
        GdsName gdsName = CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)BookingHelper.getBaseProductReservation((BookingFile)bookingFile));
        if (gdsName == GdsName.SABRE) {
            return "200";
        }
        if ("AMADEUS".equalsIgnoreCase(gdsName.name())) {
            return "300";
        }
        throw new PGException("Unsupported reservation system name " + gdsName);
    }

    private void addMeanTypeParam(String meanType) {
        if (!meanType.equalsIgnoreCase("")) {
            this.addFormParam(this.namedValue("MeanType", meanType));
        }
    }

    private void setBasicRedirectFormProps() {
        this.initiateResult.getRedirectForm().setUrl(this.unitellerSettings.getRedirectUrl());
        this.initiateResult.getRedirectForm().setMethod("POST");
    }

    protected void addSabreCardMatchingValues() {
        String buildAcceptableCardValue = SplitPaymentHelper.buildAcceptableCardValue((Payment)this.initiateResult.getPayment(), unitellerCardVendors);
        if (!TextUtil.isBlank((String)buildAcceptableCardValue)) {
            this.addFormParam(this.namedValue("IDataGDS[SabreCardIssuerMap]", buildAcceptableCardValue));
        } else {
            log.warn("Reservation system card parametes isn't added");
        }
    }

    private void addSecuritySignature(String orderId, String totalPrice, String shopId, String meanType, String paymentType) {
        String separator = "&";
        String sigValue = "";
        String empty = "d41d8cd98f00b204e9800998ecf8427e";
        sigValue = MiscUtil.md5((String)shopId) + separator + MiscUtil.md5((String)orderId) + separator + MiscUtil.md5((String)totalPrice) + separator + MiscUtil.md5((String)meanType) + separator + MiscUtil.md5((String)paymentType) + separator + "d41d8cd98f00b204e9800998ecf8427e" + separator + "d41d8cd98f00b204e9800998ecf8427e" + separator + "d41d8cd98f00b204e9800998ecf8427e" + separator + "d41d8cd98f00b204e9800998ecf8427e" + separator + "d41d8cd98f00b204e9800998ecf8427e" + separator + MiscUtil.md5((String)this.settings.getPassword());
        String totalmd5 = MiscUtil.md5((String)sigValue);
        String signature = totalmd5.toUpperCase();
        this.initiateResult.getRedirectForm().getParameters().add(this.namedValue("Signature", signature));
    }

    private String getMeanType() {
        if (this.unitellerSettings.isTestMode()) {
            return "";
        }
        switch (this.initiateParams.getPayment().getPaymentType()) {
            case CREDIT_CARD_UNITELLER: {
                return "0";
            }
        }
        return "";
    }

    private String getPaymentType() {
        if (this.unitellerSettings.isTestMode()) {
            return "";
        }
        switch (this.initiateParams.getPayment().getPaymentType()) {
            case CREDIT_CARD_UNITELLER: {
                return "0";
            }
            case DENGI_MAIL_RU_UNITELLER: {
                return "7";
            }
            case EASY_PAY_UNITELLER: {
                return "5";
            }
            case EUROSET_UNITELLER: {
                return "13";
            }
            case MOBILE_PAYMENT_BEELINE_UNITELLER: {
                return "10";
            }
            case MOBILE_PAYMENT_MEGAFON_UNITELLER: {
                return "8";
            }
            case MOBILE_PAYMENT_MTS_UNITELLER: {
                return "9";
            }
            case MONEYBOOKERS_UNITELLER: {
                return "17";
            }
            case MONEY_MAIL_UNITELLER: {
                return "3";
            }
            case PAYPAL_UNITELLER: {
                return "11";
            }
            case PLATEZH_RU_UNITELLER: {
                return "6";
            }
            case PLAT_FON_UNITELLER: {
                return "16";
            }
            case QIWI_WALLET_UNITELLER: {
                return "15";
            }
            case RBK_MONEY_UNITELLER: {
                return "2";
            }
            case VKONTAKTE_UNITELLER: {
                return "12";
            }
            case WEB_CREDS_UNITELLER: {
                return "4";
            }
            case WEB_MONEY_WMR_UNITELLER: {
                return "29";
            }
            case YANDEX_MONEY_UNITELLER: {
                return "1";
            }
            case YOTA_MONEY_UNITELLER: {
                return "14";
            }
        }
        return "";
    }

    private void addSplitSecuritySignature(String subtotal, String gdsid, String commision, String idToBank, String meanType, String emoneyType, String orderId) {
        String separator = "&";
        String sigValue = "";
        String empty = "d41d8cd98f00b204e9800998ecf8427e";
        sigValue = MiscUtil.md5((String)this.settings.getShopIdpPrimary()) + separator + MiscUtil.md5((String)orderId) + separator + MiscUtil.md5((String)subtotal) + separator + MiscUtil.md5((String)gdsid) + separator + MiscUtil.md5((String)commision) + separator + MiscUtil.md5((String)idToBank) + separator + MiscUtil.md5((String)meanType) + separator + MiscUtil.md5((String)emoneyType) + separator + empty + separator + empty + separator + empty + separator + empty + separator + empty + separator + MiscUtil.md5((String)this.settings.getPassword());
        String totalmd5 = MiscUtil.md5((String)sigValue);
        String signature = totalmd5.toUpperCase();
        this.initiateResult.getRedirectForm().getParameters().add(this.namedValue("Signature", signature));
    }

    protected NamedValue namedValue(String name, String value) {
        NamedValue nv = new NamedValue();
        nv.setName(name);
        nv.setValue(value);
        return nv;
    }

    static {
        defaultCardCodes.put(CardVendor.VISA, "BA");
        defaultCardCodes.put(CardVendor.MASTERCARD, "CA");
        unitellerCardVendors.put(CardVendor.MASTERCARD, "EURO");
        unitellerCardVendors.put(CardVendor.VISA, "VISA");
        unitellerCardVendors.put(CardVendor.AMEX, "AMEX");
        unitellerCardVendors.put(CardVendor.JCB, "JCB");
        unitellerCardVendors.put(CardVendor.DINERS_CLUB, "DCL");
    }
}

