/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.uniteller;

import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.pg.PGException;

public class MerchantSettings {
    private final PGParameters pgParameters;
    private String shopIdpPrimary;
    private String shopIdpSecondary;
    private String login;
    private boolean isUseSplitAuth;

    public String getPassword() {
        return this.pgParameters.getPgPassword();
    }

    public String getShopIdpPrimary() {
        return this.shopIdpPrimary;
    }

    public String getShopIdpSecondary() {
        return this.shopIdpSecondary;
    }

    public String getLogin() {
        return this.login;
    }

    public boolean isUseSplitAuth() {
        return this.isUseSplitAuth;
    }

    public MerchantSettings(PGParameters pgParameters) throws PGException {
        this.pgParameters = pgParameters;
        if (!this.isValid()) {
            throw new PGException("pgParameters invalid");
        }
        this.calculateShop_IDP_Primary();
        this.calculateLogin();
        this.calculateShop_IDP_Secondary();
        this.calculateSplitAuth();
    }

    private void calculateShop_IDP_Primary() {
        String[] vals;
        if (this.pgParameters.getPgAccount().contains(";") && (vals = this.pgParameters.getPgAccount().split(";")).length > 0) {
            this.shopIdpPrimary = vals[0];
        }
    }

    private void calculateLogin() {
        String[] vals = this.pgParameters.getPgAccount().split(";");
        if (vals.length > 1) {
            this.login = vals[1];
            return;
        }
        this.login = "";
    }

    private void calculateShop_IDP_Secondary() {
        String[] vals = this.pgParameters.getPgAccount().split(";");
        if (vals.length == 3 && !"0".equals(vals[2]) && !"1".equals(vals[2])) {
            this.shopIdpSecondary = vals[2];
            return;
        }
        if (vals.length == 4) {
            this.shopIdpSecondary = vals[3];
            return;
        }
        this.shopIdpSecondary = "";
    }

    private void calculateSplitAuth() {
        String[] vals = this.pgParameters.getPgAccount().split(";");
        if (vals.length == 3 && ("0".equals(vals[2]) || "1".equals(vals[2]))) {
            this.isUseSplitAuth = "1".equals(vals[2]);
            return;
        }
        if (vals.length == 4) {
            this.isUseSplitAuth = "1".equals(vals[2]);
            return;
        }
    }

    public boolean isValid() {
        if (this.pgParameters == null) {
            return false;
        }
        if (TextUtil.isBlank((String)this.pgParameters.getPgAccount())) {
            return false;
        }
        return !TextUtil.isBlank((String)this.pgParameters.getPgPassword());
    }
}

