/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.uniteller;

import com.gridnine.xtrip.common.model.system.CardTransactionDetails;
import com.gridnine.xtrip.server.pg.uniteller.CheckOrder;
import com.gridnine.xtrip.server.pg.uniteller.TransactionRecord;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderTransactions {
    private static final Logger log = LoggerFactory.getLogger(CheckOrder.class);
    private final List<TransactionRecord> transactions;

    public OrderTransactions(List<TransactionRecord> transactions) {
        this.transactions = transactions;
    }

    public List<TransactionRecord> getTransactions() {
        return this.transactions;
    }

    public BigDecimal getPayedTotal() {
        BigDecimal result = BigDecimal.ZERO;
        for (TransactionRecord paymentRecord : this.transactions) {
            String status = paymentRecord.getStatus();
            if (this.isAutorizedOrPayed(status)) {
                log.debug("Sum status: " + status);
                result = result.add(paymentRecord.getSum());
                continue;
            }
            log.debug("Skip status: " + status);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.transactions.isEmpty();
    }

    private boolean isAutorizedOrPayed(String status) {
        return "Authorized".equalsIgnoreCase(status) || "Paid".equalsIgnoreCase(status);
    }

    public Optional<String> getGdsApprovalCode() {
        Optional<String> result = this.getTransactions().stream().filter(TransactionRecord::isGdsTransaction).map(TransactionRecord::getApprovalCode).findAny();
        result.ifPresent(app -> log.trace(String.format("Found %s gds approval code - save in Reservation", app)));
        return result;
    }

    public CardTransactionDetails createCardDetails() {
        try {
            CardTransactionDetails details = new CardTransactionDetails();
            details.setTransactionCode(this.transactions.get(0).getBillNumber());
            details.setNameOnCard(this.transactions.get(0).getCardHolder());
            details.setNumber(this.transactions.get(0).getCardNumber());
            details.setSecurityCode(this.transactions.get(0).getApprovalCode());
            details.setVendor(this.transactions.get(0).getCardVendor());
            return details;
        }
        catch (Exception e) {
            log.error("createCardDetails error", (Throwable)e);
            return null;
        }
    }

    public List<String> getBillingNumbersToConfirm() {
        return this.getTransactions().stream().filter(TransactionRecord::isNeedConfirm).map(TransactionRecord::getBillNumber).collect(Collectors.toList());
    }
}

