/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.uniteller;

import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.uniteller.UnitellerSettings;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.uniteller.MerchantSettings;
import com.gridnine.xtrip.server.pg.uniteller.SFieldsList;
import com.gridnine.xtrip.server.pg.uniteller.UnitellerHelper;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefundBillingPayment {
    protected static final Logger log = LoggerFactory.getLogger(RefundBillingPayment.class);
    private final DecimalFormat priceFormatter;
    private final MerchantSettings settings;
    private final UnitellerSettings config;
    private final BigDecimal sumToRefund;
    private final String billNumber;
    private final String bookingNumber;

    public RefundBillingPayment(MerchantSettings settings, UnitellerSettings config, BigDecimal sumToRefund, String billNumber, String bookingNumber) {
        this.settings = settings;
        this.config = config;
        this.sumToRefund = sumToRefund;
        this.billNumber = billNumber;
        this.bookingNumber = bookingNumber;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        this.priceFormatter = new DecimalFormat("0.00", dfs);
    }

    public boolean execute() {
        log.trace(String.format("Refund sum [%.2f] from BookingFile [%s] using billNumber [%s]", this.sumToRefund, this.bookingNumber, this.billNumber));
        Date startDate = new Date();
        HashMap<String, String> params = new HashMap<String, String>();
        StringBuilder serverResponse = new StringBuilder();
        try {
            this.setParams(params);
            serverResponse.append(UnitellerHelper.executeHttpConnection(this.createConnection(), params));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.PAYMENT_REFUND.toString(), params, (Object)serverResponse, null);
            if (this.isErrorResponse(serverResponse)) {
                log.error("Payment refund error: " + serverResponse);
                return false;
            }
            log.debug(String.format("Refund sum [%.2f] from BookingFile [%s] using billNumber [%s] was successfull", this.sumToRefund, this.bookingNumber, this.billNumber));
            return true;
        }
        catch (Exception e) {
            PGInvocationContext.get().addTraceData(startDate, InvocationName.PAYMENT_REFUND.toString(), params, (Object)serverResponse, (Throwable)e);
            log.error("refund error", (Throwable)e);
            return false;
        }
    }

    private HttpsURLConnection createConnection() throws IOException {
        URL url = new URL(this.config.getRefundUrl());
        return (HttpsURLConnection)url.openConnection();
    }

    private void setParams(Map<String, String> params) {
        params.put("Shop_ID", this.settings.getShopIdpPrimary());
        params.put("Login", this.settings.getLogin());
        params.put("Password", this.settings.getPassword());
        params.put("Billnumber", this.billNumber);
        params.put("Format", "1");
        params.put("Subtotal_P", this.priceFormatter.format(this.sumToRefund));
        ArrayList<String> sfieldsParams = new ArrayList<String>();
        sfieldsParams.add("Status");
        sfieldsParams.add("Total");
        sfieldsParams.add("ApprovalCode");
        sfieldsParams.add("BillNumber");
        SFieldsList sfieldsList = new SFieldsList();
        params.put("S_FIELDS", sfieldsList.getRequestSFieldsValue());
    }

    private boolean isErrorResponse(StringBuilder serverResponse) {
        return serverResponse.indexOf("Error") > -1;
    }
}

